/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.TradingService;
import org.jacorb.trading.db.simple.offers.OfferProperty;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.RegisterPackage.OfferInfo;

public class Offer
implements Serializable {
    private String m_id;
    private String m_object;
    private Vector m_props;
    private transient OfferInfo m_description;
    static final long serialVersionUID = 4241426996695613295L;

    private Offer() {
    }

    public Offer(String id, Object obj, Property[] props) {
        this.m_id = id;
        this.m_object = TradingService.getORB().object_to_string(obj);
        this.setProperties(props);
        this.m_description = null;
    }

    public OfferInfo describe() {
        OfferInfo result = null;
        if (this.m_description == null) {
            result = new OfferInfo();
            result.reference = TradingService.getORB().string_to_object(this.m_object);
            result.properties = new Property[this.m_props.size()];
            int count = 0;
            Enumeration e = this.m_props.elements();
            while (e.hasMoreElements()) {
                OfferProperty prop = (OfferProperty)e.nextElement();
                result.properties[count] = prop.describe();
                ++count;
            }
            this.m_description = result;
        } else {
            result = this.m_description;
        }
        return result;
    }

    public void modify(Property[] props) {
        this.setProperties(props);
        this.m_description = null;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public boolean equals(java.lang.Object o) {
        Offer offer = (Offer)o;
        return this.m_id.equals(offer.m_id);
    }

    protected void setProperties(Property[] props) {
        this.m_props = new Vector();
        for (int i = 0; i < props.length; ++i) {
            OfferProperty prop = new OfferProperty(props[i]);
            this.m_props.addElement(prop);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_description = null;
    }
}

