/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class LongValue
implements Value {
    private Integer m_value;

    public LongValue() {
        this(0);
    }

    public LongValue(int value) {
        this.m_value = new Integer(value);
    }

    public LongValue(Object value) {
        this.m_value = (Integer)value;
    }

    public void setValue(Object value) {
        this.m_value = (Integer)value;
    }

    public int getTypeId() {
        return 3;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = this.m_value < i;
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        LongValue result = null;
        if (nv.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = new LongValue(this.m_value + i);
        return result;
    }

    public Value minus(Value nv) {
        LongValue result = null;
        if (nv.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = new LongValue(this.m_value - i);
        return result;
    }

    public Value multiply(Value nv) {
        LongValue result = null;
        if (nv.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = new LongValue(this.m_value * i);
        return result;
    }

    public Value divide(Value nv) {
        LongValue result = null;
        if (nv.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = new LongValue(this.m_value / i);
        return result;
    }

    public Value negate() {
        LongValue result = null;
        result = new LongValue(-1 * this.m_value);
        return result;
    }

    public Value convert(int typeId) {
        Value result = null;
        switch (typeId) {
            case 3: {
                result = new LongValue(this.m_value);
                break;
            }
            case 4: {
                result = ValueFactory.createULong(this.m_value.longValue());
                break;
            }
            case 5: {
                result = ValueFactory.createFloat(this.m_value.floatValue());
                break;
            }
            case 6: {
                result = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

