/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;

public class BooleanValue
implements Value {
    private Boolean m_value;

    public BooleanValue() {
        this(false);
    }

    public BooleanValue(boolean value) {
        this.m_value = new Boolean(value);
    }

    public BooleanValue(Object value) {
        this.m_value = (Boolean)value;
    }

    public void setValue(Object value) {
        this.m_value = (Boolean)value;
    }

    public int getTypeId() {
        return 0;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 0) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 0) {
            throw new IllegalArgumentException();
        }
        Boolean b = (Boolean)nv.getValue();
        result = this.m_value == false && b == true;
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        throw new ArithmeticException();
    }

    public Value minus(Value nv) {
        throw new ArithmeticException();
    }

    public Value multiply(Value nv) {
        throw new ArithmeticException();
    }

    public Value divide(Value nv) {
        throw new ArithmeticException();
    }

    public Value negate() {
        throw new ArithmeticException();
    }

    public Value convert(int typeId) {
        BooleanValue result = null;
        if (typeId != 0) {
            throw new IllegalArgumentException();
        }
        result = new BooleanValue(this.m_value);
        return result;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

