/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.offers;

import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jacorb.trading.client.offers.ConstraintDialog;
import org.jacorb.trading.client.util.AnyUtil;
import org.jacorb.trading.client.util.ConfirmDialog;
import org.jacorb.trading.client.util.Constrain;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.IllegalOfferId;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.NotImplemented;
import org.omg.CosTrading.OfferIdIteratorHolder;
import org.omg.CosTrading.OfferIdSeqHolder;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPackage.NotProxyOfferId;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTrading.RegisterPackage.ProxyOfferId;
import org.omg.CosTrading.UnknownOfferId;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;

public class Offers
extends Frame
implements ActionListener,
ItemListener,
Runnable {
    private Choice m_view;
    private List m_offers;
    private TextArea m_description;
    private Button m_refresh;
    private Button m_withdraw;
    private Button m_withdrawConstraint;
    private Label m_status;
    private ConstraintDialog m_constraintDialog;
    private Admin m_admin;
    private Register m_register;
    private Proxy m_proxy;
    private static ORB s_orb;

    public Offers(Admin admin, Register reg, Proxy proxy) {
        super("Service Offers");
        this.setFont(new Font("Helvetica", 0, 12));
        this.m_admin = admin;
        this.m_register = reg;
        this.m_proxy = proxy;
        this.createContents();
        this.refreshOffers();
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel selectPanel = new Panel();
        selectPanel.setLayout(new FlowLayout(0, 0, 0));
        selectPanel.add(new Label("View", 0));
        this.m_view = new Choice();
        this.m_view.add("Offers");
        this.m_view.add("Proxy Offers");
        this.m_view.addItemListener(this);
        selectPanel.add(this.m_view);
        Constrain.constrain(panel, selectPanel, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 0, 5);
        Panel offersPanel = new Panel();
        offersPanel.setLayout(new GridBagLayout());
        Constrain.constrain(offersPanel, new Label("Offers", 0), 0, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_offers = new List(10, false);
        this.m_offers.addItemListener(this);
        Constrain.constrain(offersPanel, this.m_offers, 0, 1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, offersPanel, 0, 1, 1, 1, 1, 18, 0.25, 1.0, 5, 10, 5, 5);
        Panel infoPanel = new Panel();
        infoPanel.setLayout(new GridBagLayout());
        Constrain.constrain(infoPanel, new Label("Offer information", 0), 0, 0, 2, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_description = new TextArea(10, 40);
        this.m_description.setEditable(false);
        Constrain.constrain(infoPanel, this.m_description, 0, 1, 2, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, infoPanel, 1, 1, 1, 1, 1, 12, 0.75, 1.0, 5, 5, 5, 10);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout());
        this.m_refresh = new Button("Refresh");
        this.m_refresh.setActionCommand("refresh");
        this.m_refresh.addActionListener(this);
        buttonPanel.add(this.m_refresh);
        this.m_withdraw = new Button("Withdraw...");
        this.m_withdraw.setActionCommand("withdraw");
        this.m_withdraw.addActionListener(this);
        buttonPanel.add(this.m_withdraw);
        this.m_withdrawConstraint = new Button("Withdraw using constraint...");
        this.m_withdrawConstraint.setActionCommand("withdrawConstraint");
        this.m_withdrawConstraint.addActionListener(this);
        buttonPanel.add(this.m_withdrawConstraint);
        Constrain.constrain(panel, buttonPanel, 0, 2, 2, 1, 0, 18, 0.0, 0.0, 5, 5, 0, 10);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 3, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 3, 10);
        this.add(panel);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.m_view) {
            this.refreshOffers();
        } else if (e.getItemSelectable() == this.m_offers) {
            this.updateButtons();
            this.clearStatus();
            if (e.getStateChange() == 1) {
                this.describe();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("refresh")) {
            this.refreshOffers();
        } else if (cmd.equals("withdrawConstraint")) {
            if (this.m_constraintDialog == null) {
                this.m_constraintDialog = new ConstraintDialog((Frame)this, this.m_register);
                this.m_constraintDialog.setActionCommand("refresh");
                this.m_constraintDialog.addActionListener(this);
            }
            this.clearStatus();
            this.m_constraintDialog.setVisible(true);
        } else if (cmd.equals("withdraw")) {
            String id = this.m_offers.getSelectedItem();
            ConfirmDialog confirm = new ConfirmDialog((Frame)this, "Remove offer '" + id + "'?");
            confirm.setActionCommand("confirm");
            confirm.addActionListener(this);
            this.clearStatus();
            confirm.setVisible(true);
        } else if (cmd.equals("confirm")) {
            this.removeOffer();
        }
    }

    protected void removeOffer() {
        try {
            String id = this.m_offers.getSelectedItem();
            if (this.m_view.getSelectedItem().equals("Offers")) {
                this.m_register.withdraw(id);
            } else {
                this.m_proxy.withdraw_proxy(id);
            }
            this.m_offers.remove(id);
            this.m_description.setText("");
            this.clearStatus();
            this.updateButtons();
        }
        catch (IllegalOfferId e) {
            this.showStatus("Illegal offer ID '" + e.id + "'");
        }
        catch (UnknownOfferId e) {
            this.showStatus("Unknown offer ID '" + e.id + "'");
        }
        catch (ProxyOfferId e) {
            this.showStatus("Offer '" + e.id + "' is a proxy");
        }
        catch (NotProxyOfferId e) {
            this.showStatus("Offer '" + e.id + "' is not a proxy");
        }
    }

    protected void refreshOffers() {
        new Thread(this).start();
    }

    public void run() {
        this.showStatus("Refreshing offers...");
        this.m_offers.removeAll();
        this.m_description.setText("");
        this.updateButtons();
        try {
            OfferIdSeqHolder ids = new OfferIdSeqHolder();
            OfferIdIteratorHolder iter = new OfferIdIteratorHolder();
            if (this.m_view.getSelectedItem().equals("Offers")) {
                this.m_admin.list_offers(100, ids, iter);
            } else {
                this.m_admin.list_proxies(100, ids, iter);
            }
            int count = ids.value.length;
            this.showStatus("Received " + count + " offers...");
            for (int i = 0; i < ids.value.length; ++i) {
                this.m_offers.add(ids.value[i]);
            }
            if (iter.value != null) {
                boolean more;
                OfferIdSeqHolder seq = new OfferIdSeqHolder();
                do {
                    more = iter.value.next_n(100, seq);
                    this.showStatus("Received " + (count += seq.value.length) + " offers...");
                    for (int i = 0; i < seq.value.length; ++i) {
                        this.m_offers.add(seq.value[i]);
                    }
                } while (more);
                iter.value.destroy();
            }
        }
        catch (NotImplemented e) {
            this.showStatus("Admin::list_offers not implemented");
        }
    }

    protected void updateButtons() {
        if (this.m_offers.getSelectedIndex() < 0) {
            this.m_withdraw.setEnabled(false);
        } else {
            this.m_withdraw.setEnabled(true);
        }
        if (this.m_view.getSelectedItem().equals("Offers")) {
            this.m_withdrawConstraint.setEnabled(true);
        } else {
            this.m_withdrawConstraint.setEnabled(false);
        }
    }

    protected void describe() {
        String id = this.m_offers.getSelectedItem();
        if (this.m_view.getSelectedItem().equals("Offers")) {
            this.describeOffer(id);
        } else {
            this.describeProxy(id);
        }
    }

    protected void describeOffer(String id) {
        try {
            OfferInfo info = this.m_register.describe(id);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Type: " + info.type);
            pw.println();
            this.describeProperties(pw, info.properties);
            pw.println();
            pw.println("Reference:");
            String ref = s_orb.object_to_string(info.reference);
            pw.println("  " + ref);
            pw.flush();
            this.m_description.setText(sw.toString());
        }
        catch (IllegalOfferId e) {
            this.showStatus("Illegal offer ID '" + e.id + "'");
        }
        catch (UnknownOfferId e) {
            this.showStatus("Unknown offer ID '" + e.id + "'");
        }
        catch (ProxyOfferId e) {
            this.showStatus("Offer '" + e.id + "' is a proxy");
        }
    }

    protected void describeProxy(String id) {
        try {
            ProxyInfo info = this.m_proxy.describe_proxy(id);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Type: " + info.type);
            pw.println();
            this.describeProperties(pw, info.properties);
            pw.println();
            pw.println("Target:");
            String ref = s_orb.object_to_string(info.target);
            pw.println("  " + ref);
            pw.println();
            pw.println("If match all: " + info.if_match_all);
            pw.println();
            pw.println("Recipe:");
            pw.println("  " + info.recipe);
            pw.println();
            pw.println("Policies to pass on:");
            for (int p = 0; p < info.policies_to_pass_on.length; ++p) {
                pw.print("  " + info.policies_to_pass_on[p].name + " = ");
                AnyUtil.print(s_orb, pw, info.policies_to_pass_on[p].value);
                pw.println();
            }
            pw.flush();
            this.m_description.setText(sw.toString());
        }
        catch (IllegalOfferId e) {
            this.showStatus("Illegal offer ID '" + e.id + "'");
        }
        catch (UnknownOfferId e) {
            this.showStatus("Unknown offer ID '" + e.id + "'");
        }
        catch (NotProxyOfferId e) {
            this.showStatus("Offer '" + e.id + "' is not a proxy");
        }
    }

    protected void describeProperties(PrintWriter pw, Property[] props) {
        pw.println("Properties:");
        for (int p = 0; p < props.length; ++p) {
            pw.print("  " + props[p].name + " = ");
            TypeCode tc = props[p].value.type();
            if (tc.equal(DynamicPropHelper.type())) {
                pw.println("<Dynamic>");
                DynamicProp dp = DynamicPropHelper.extract(props[p].value);
                pw.print("    eval_if = ");
                String ref = s_orb.object_to_string(dp.eval_if);
                pw.println(ref);
                pw.print("    returned_type = ");
                AnyUtil.print(pw, dp.returned_type);
                pw.println();
                pw.print("    extra_info = ");
                AnyUtil.print(s_orb, pw, dp.extra_info);
                pw.println();
                continue;
            }
            AnyUtil.print(s_orb, pw, props[p].value);
            pw.println();
        }
    }

    protected void showStatus(String message) {
        this.m_status.setText(message);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected static void usage() {
        System.out.println("Usage: Offers iorfile");
        System.exit(1);
    }

    public static void main(String[] args) {
        s_orb = ORB.init(args, null);
        Admin admin = null;
        Register reg = null;
        Proxy proxy = null;
        try {
            Object obj = s_orb.resolve_initial_references("TradingService");
            if (obj == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow(obj);
            admin = lookup.admin_if();
            reg = lookup.register_if();
            proxy = lookup.proxy_if();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Offers app = new Offers(admin, reg, proxy);
        app.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        app.pack();
        app.setVisible(true);
    }
}

