/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class PrintIOR {
    static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        orb = org.omg.CORBA.ORB.init(args, null);
        logger = ((ORB)orb).getConfiguration().getNamedLogger("jacorb.print_ior");
        iorString = null;
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: java PrintIOR [ ior_str | -f filename ]");
            System.exit(1);
        }
        if (args[0].equals("-f")) {
            try {
                br = new BufferedReader(new FileReader(args[1]), 2048);
                line = br.readLine();
                if (line == null) ** GOTO lbl24
                iorString = line;
                while (line != null) {
                    line = br.readLine();
                    if (line == null) continue;
                    iorString = iorString + line;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(1);
            }
        } else {
            iorString = args[0];
        }
lbl24:
        // 4 sources

        if (iorString.startsWith("IOR:")) {
            pior = new ParsedIOR(iorString, orb, logger);
            PrintIOR.printIOR(pior, orb);
        } else {
            System.out.println("Sorry, we only unparse IORs in the standard IOR URL scheme");
        }
        orb.shutdown(true);
    }

    public static void printIOR(ParsedIOR pior, org.omg.CORBA.ORB orb) {
        IOR ior = pior.getIOR();
        System.out.println("------IOR components-----");
        System.out.println("TypeId\t:\t" + ior.type_id);
        List profiles = pior.getProfiles();
        System.out.println("TAG_INTERNET_IOP Profiles:");
        for (int i = 0; i < profiles.size(); ++i) {
            System.out.print("\tProfile Id:  ");
            IIOPProfile p = (IIOPProfile)profiles.get(i);
            System.out.println("\tIIOP Version :  " + p.version().major + "." + p.version().minor);
            System.out.println("\tHost\t:\t" + ((IIOPAddress)p.getAddress()).getOriginalHost());
            int port = ((IIOPAddress)p.getAddress()).getPort();
            if (port < 0) {
                port += 65536;
            }
            System.out.println("\tPort\t:\t" + port);
            try {
                System.out.println("\tObject key (URL):      " + CorbaLoc.parseKey(pior.get_object_key()));
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.print("\tObject key (hex):    0x");
            PrintIOR.dumpHex(pior.get_object_key());
            System.out.println();
            if (p.version().minor >= 1) {
                if (p.getComponents().size() > 0) {
                    System.out.println("\t-- Found " + p.getComponents().size() + " Tagged Components--");
                }
                PrintIOR.printTaggedComponents(p.getComponents().asArray());
            }
            System.out.print("\n");
        }
        TaggedComponentList multiple_components = pior.getMultipleComponents();
        if (multiple_components.size() > 0) {
            System.out.println("Components in MULTIPLE_COMPONENTS profile: " + multiple_components.size());
            PrintIOR.printTaggedComponents(multiple_components.asArray());
        }
    }

    private static void printTaggedComponents(TaggedComponent[] taggedComponents) {
        block10: for (int i = 0; i < taggedComponents.length; ++i) {
            switch (taggedComponents[i].tag) {
                case 20: {
                    System.out.println("\t#" + i + ": TAG_SSL_SEC_TRANS");
                    PrintIOR.printSSLTaggedComponent(taggedComponents[i]);
                    continue block10;
                }
                case 33: {
                    System.out.println("\t#" + i + ": TAG_CSI_SEC_MECH_LIST");
                    PrintIOR.printCSIMechComponent(taggedComponents[i]);
                    continue block10;
                }
                case 35: {
                    System.out.println("\t#" + i + ": TAG_SECIOP_SEC_TRANS");
                    continue block10;
                }
                case 3: {
                    System.out.println("\t#" + i + ": TAG_ALTERNATE_IIOP_ADDRESS");
                    PrintIOR.printAlternateAddress(taggedComponents[i]);
                    continue block10;
                }
                case 1: {
                    System.out.println("\t#" + i + ": TAG_CODE_SETS");
                    PrintIOR.printCodeSetComponent(taggedComponents[i]);
                    continue block10;
                }
                case 25: {
                    System.out.println("\t#" + i + ": TAG_JAVA_CODEBASE");
                    PrintIOR.printJavaCodebaseComponent(taggedComponents[i]);
                    continue block10;
                }
                case 0: {
                    System.out.println("\t#" + i + ": TAG_ORB_TYPE");
                    PrintIOR.printOrbTypeComponent(taggedComponents[i]);
                    continue block10;
                }
                case 34: {
                    System.out.println("\t#" + i + ": TAG_NULL_TAG");
                    continue block10;
                }
                default: {
                    System.out.println("\tUnknown tag : " + taggedComponents[i].tag);
                }
            }
        }
    }

    private static void printCSIMechComponent(TaggedComponent taggedComponent) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        is.openEncapsulatedArray();
        CompoundSecMechList csmList = CompoundSecMechListHelper.read(is);
        if (csmList != null) {
            System.out.println("\t\tis stateful: " + csmList.stateful);
            for (int i = 0; i < csmList.mechanism_list.length; ++i) {
                System.out.println("\t\tCompoundSecMech #" + i);
                System.out.println("\t\t\ttarget_requires: " + csmList.mechanism_list[i].target_requires);
                System.out.print("\t\t\ttransport mechanism tag: ");
                switch (csmList.mechanism_list[i].transport_mech.tag) {
                    case 36: {
                        System.out.println("TAG_TLS_SEC_TRANS");
                        PrintIOR.printTlsSecTrans(csmList.mechanism_list[i].transport_mech.component_data);
                        break;
                    }
                    case 34: {
                        System.out.println("TAG_NULL_TAG");
                        break;
                    }
                    default: {
                        System.out.println("Unknown tag : " + csmList.mechanism_list[i].transport_mech.tag);
                    }
                }
                System.out.println("\t\t\tAS_ContextSec target_supports: " + csmList.mechanism_list[i].as_context_mech.target_supports);
                System.out.println("\t\t\tAS_ContextSec target_requires: " + csmList.mechanism_list[i].as_context_mech.target_requires);
                System.out.print("\t\t\tAS_ContextSec mech: ");
                PrintIOR.dumpHex(csmList.mechanism_list[i].as_context_mech.client_authentication_mech);
                System.out.println();
                System.out.print("\t\t\tAS_ContextSec target_name: ");
                PrintIOR.printNTExportedName(csmList.mechanism_list[i].as_context_mech.target_name);
                System.out.println("\t\t\tSAS_ContextSec target_supports: " + csmList.mechanism_list[i].sas_context_mech.target_supports);
                System.out.println("\t\t\tSAS_ContextSec target_requires: " + csmList.mechanism_list[i].sas_context_mech.target_requires);
                for (int j = 0; j < csmList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms.length; ++j) {
                    System.out.print("\t\t\tSAS_ContextSec Naming mech: ");
                    PrintIOR.dumpHex(csmList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms[j]);
                    System.out.println();
                }
                System.out.println("\t\t\tSAS_ContextSec Naming types: " + csmList.mechanism_list[i].sas_context_mech.supported_identity_types);
                System.out.println();
            }
        }
    }

    private static void printNTExportedName(byte[] nameData) {
        if (nameData.length < 2 || nameData[0] != 4 || nameData[1] != 1) {
            PrintIOR.dumpHex(nameData);
            System.out.println();
            return;
        }
        int mechLen = (nameData[2] << 8) + nameData[3];
        if (mechLen > nameData.length - 8) {
            PrintIOR.dumpHex(nameData);
            System.out.println();
            return;
        }
        int nameLen = (nameData[mechLen + 4] << 24) + (nameData[mechLen + 5] << 16) + (nameData[mechLen + 6] << 8) + nameData[mechLen + 7];
        if (mechLen + nameLen > nameData.length - 8) {
            PrintIOR.dumpHex(nameData);
            System.out.println();
            return;
        }
        byte[] name = new byte[nameLen];
        System.arraycopy(nameData, mechLen + 8, name, 0, nameLen);
        System.out.println(new String(name));
    }

    private static void printTlsSecTrans(byte[] tagData) {
        CDRInputStream in = new CDRInputStream(null, tagData);
        try {
            in.openEncapsulatedArray();
            TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.read(in);
            System.out.println("\t\t\tTLS SEC TRANS target requires: " + tls.target_requires);
            System.out.println("\t\t\tTLS SEC TRANS target supports: " + tls.target_supports);
            for (int i = 0; i < tls.addresses.length; ++i) {
                int ssl_port = tls.addresses[i].port;
                if (ssl_port < 0) {
                    ssl_port += 65536;
                }
                System.out.println("\t\t\tTLS SEC TRANS address: " + tls.addresses[i].host_name + ":" + ssl_port);
            }
        }
        catch (Exception ex) {
            System.out.print("\t\t\tTLS SEC TRANS: ");
            PrintIOR.dumpHex(tagData);
            System.out.println();
        }
    }

    private static void printCodeSetComponent(TaggedComponent taggedComponent) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        is.openEncapsulatedArray();
        CodeSetComponentInfo codeSet = CodeSetComponentInfoHelper.read(is);
        if (codeSet != null) {
            int ji;
            System.out.println("\t\tForChar native code set Id: " + CodeSet.csName(codeSet.ForCharData.native_code_set));
            System.out.print("\t\tChar Conversion Code Sets: ");
            for (ji = 0; ji < codeSet.ForCharData.conversion_code_sets.length; ++ji) {
                System.out.println(CodeSet.csName(codeSet.ForCharData.conversion_code_sets[ji]));
                if (ji >= codeSet.ForCharData.conversion_code_sets.length - 1) continue;
                System.out.print(", ");
            }
            System.out.println("\t\tForWChar native code set Id: " + CodeSet.csName(codeSet.ForWcharData.native_code_set));
            System.out.print("\t\tWChar Conversion Code Sets: ");
            for (ji = 0; ji < codeSet.ForWcharData.conversion_code_sets.length; ++ji) {
                System.out.println(CodeSet.csName(codeSet.ForWcharData.conversion_code_sets[ji]));
                if (ji >= codeSet.ForWcharData.conversion_code_sets.length - 1) continue;
                System.out.print(", ");
            }
        }
    }

    private static void printSSLTaggedComponent(TaggedComponent taggedComponent) {
        SSL ssl = null;
        if (taggedComponent.tag == 20) {
            CDRInputStream in = new CDRInputStream(null, taggedComponent.component_data);
            try {
                in.openEncapsulatedArray();
                ssl = SSLHelper.read(in);
            }
            catch (Exception ex) {
                return;
            }
            int ssl_port = ssl.port;
            if (ssl_port < 0) {
                ssl_port += 65536;
            }
            System.out.print("\t\ttarget_supports\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_supports);
            System.out.println();
            System.out.print("\t\ttarget_requires\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_requires);
            System.out.println();
            System.out.println("\t\tSSL Port\t:\t" + ssl_port);
        }
    }

    private static void decodeAssociationOption(int option) {
        boolean first = true;
        if ((option & 1) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("NoProtection");
            first = false;
        }
        if ((option & 2) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("Integrity");
            first = false;
        }
        if ((option & 4) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("Confidentiality");
            first = false;
        }
        if ((option & 8) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("DetectReplay");
            first = false;
        }
        if ((option & 0x10) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("DetectMisordering");
            first = false;
        }
        if ((option & 0x20) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("EstablishTrustInTarget");
            first = false;
        }
        if ((option & 0x40) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("EstablishTrustInClient");
            first = false;
        }
        if ((option & 0x80) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("NoDelegation");
            first = false;
        }
        if ((option & 0x100) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("SimpleDelegation");
            first = false;
        }
        if ((option & 0x200) != 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print("CompositeDelegation");
            first = false;
        }
    }

    private static void printJavaCodebaseComponent(TaggedComponent taggedComponent) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        is.openEncapsulatedArray();
        String codebase = is.read_string();
        System.out.println("\t\tCodebase: " + codebase);
    }

    private static void printOrbTypeComponent(TaggedComponent tc) {
        CDRInputStream is = new CDRInputStream(null, tc.component_data);
        is.openEncapsulatedArray();
        int type = is.read_long();
        System.out.print("\t\tType: " + type);
        if (type == 1245790976) {
            System.out.println(" (JacORB)");
        } else {
            System.out.println(" (Foreign)");
        }
    }

    private static void printAlternateAddress(TaggedComponent tc) {
        CDRInputStream is = new CDRInputStream(null, tc.component_data);
        is.openEncapsulatedArray();
        System.out.println("\t\tAddress: " + IIOPAddress.read(is));
    }

    public static void dumpHex(byte[] bs) {
        for (int i = 0; i < bs.length; ++i) {
            int n1 = (bs[i] & 0xFF) / 16;
            int n2 = (bs[i] & 0xFF) % 16;
            char c1 = (char)(n1 > 9 ? 65 + (n1 - 10) : 48 + n1);
            char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
            System.out.print("" + c1 + c2 + " ");
        }
    }

    public static void dump(byte[] bs) {
        for (int i = 0; i < bs.length; ++i) {
            PrintIOR.dump(bs[i]);
            System.out.print(" ");
        }
    }

    public static void dump(int[] is) {
        for (int i = 0; i < is.length; ++i) {
            PrintIOR.dump(is[i]);
            System.out.print(" ");
        }
    }

    public static void dump(byte b) {
        System.out.print("" + hexDigit[b >> 4 & 0xF] + hexDigit[b & 0xF]);
    }

    public static void dump(short i) {
        System.out.print("" + hexDigit[i >> 12 & 0xF] + hexDigit[i >> 9 & 0xF] + hexDigit[i >> 4 & 0xF] + hexDigit[i & 0xF]);
    }

    public static void dump(int i) {
        System.out.print("" + hexDigit[i >> 28 & 0xF] + hexDigit[i >> 24 & 0xF] + hexDigit[i >> 20 & 0xF] + hexDigit[i >> 16 & 0xF] + hexDigit[i >> 12 & 0xF] + hexDigit[i >> 8 & 0xF] + hexDigit[i >> 4 & 0xF] + hexDigit[i & 0xF]);
    }

    public static void dump(byte[] bs, boolean withChar) {
        int len = bs.length;
        for (int i = 0; i < len; ++i) {
            if (0 == i % 16) {
                System.out.println();
            }
            char c = bs[i] > 31 && bs[i] < 127 ? (char)((char)bs[i]) : (char)' ';
            System.out.print(":" + hexDigit[bs[i] >> 4 & 0xF] + hexDigit[bs[i] & 0xF] + " " + c);
        }
    }
}

