/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;

public class FixIOR {
    public static void main(String[] args) throws Exception {
        int iport;
        if (args.length != 3) {
            System.err.println("Usage: fixior host port ior_file");
            System.exit(1);
        }
        String host = args[0];
        String iorFile = args[2];
        BufferedReader br = new BufferedReader(new FileReader(iorFile));
        String iorString = br.readLine();
        br.close();
        if (!iorString.startsWith("IOR:")) {
            System.err.println("IOR must be in the standard IOR URL format");
            System.exit(1);
        }
        if ((iport = Integer.parseInt(args[1])) > Short.MAX_VALUE) {
            iport -= 65536;
        }
        short port = (short)iport;
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, null);
        Logger logger = ((ORB)orb).getConfiguration().getNamedLogger("jacorb.fixior");
        ParsedIOR pior = new ParsedIOR(iorString, orb, logger);
        IOR ior = pior.getIOR();
        TaggedProfile[] profiles = ior.profiles;
        for (int i = 0; i < profiles.length; ++i) {
            if (profiles[i].tag != 0) continue;
            CDRInputStream is = new CDRInputStream(orb, profiles[i].profile_data);
            is.openEncapsulatedArray();
            ProfileBody_1_0 body10 = ProfileBody_1_0Helper.read(is);
            is.close();
            CDROutputStream os = new CDROutputStream();
            os.beginEncapsulatedArray();
            if (body10.iiop_version.minor > 0) {
                is = new CDRInputStream(orb, profiles[i].profile_data);
                is.openEncapsulatedArray();
                ProfileBody_1_1 body11 = ProfileBody_1_1Helper.read(is);
                is.close();
                body11.host = host;
                body11.port = port;
                ProfileBody_1_1Helper.write(os, body11);
            } else {
                body10.host = host;
                body10.port = port;
                ProfileBody_1_0Helper.write(os, body10);
            }
            profiles[i].profile_data = os.getBufferCopy();
        }
        pior = new ParsedIOR(ior, (ORB)orb, logger);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(iorFile)));
        bw.write(pior.getIORString());
        bw.close();
    }

    private FixIOR() {
    }
}

