/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Hashtable;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public abstract class RecursionAwareCI
extends LocalObject
implements ClientRequestInterceptor {
    private Hashtable thread_stacks = new Hashtable();
    private Hashtable ignore_operations = new Hashtable();

    public RecursionAwareCI(boolean ignore_special_ops) {
        if (ignore_special_ops) {
            this.ignore_operations.put("_is_a", "");
            this.ignore_operations.put("_get_interface", "");
            this.ignore_operations.put("_non_existent", "");
            this.ignore_operations.put("_get_policy", "");
            this.ignore_operations.put("_get_domain_managers", "");
            this.ignore_operations.put("_set_policy_overrides", "");
        }
    }

    public void addIgnoreOperation(String operation_name) {
        this.ignore_operations.put(operation_name, operation_name);
    }

    private boolean enterCall(String operation) {
        if (this.ignore_operations.containsKey(operation)) {
            return false;
        }
        Thread current = Thread.currentThread();
        if (this.thread_stacks.containsKey(current)) {
            return false;
        }
        this.thread_stacks.put(current, current);
        return true;
    }

    private void exitCall() {
        this.thread_stacks.remove(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_send_request(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send_poll(ClientRequestInfo ri) {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_send_poll(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive_reply(ClientRequestInfo ri) {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_receive_reply(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_receive_exception(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        if (this.enterCall(ri.operation())) {
            try {
                this.do_receive_other(ri);
            }
            finally {
                this.exitCall();
            }
        }
    }

    public abstract void do_send_request(ClientRequestInfo var1) throws ForwardRequest;

    public abstract void do_send_poll(ClientRequestInfo var1);

    public abstract void do_receive_reply(ClientRequestInfo var1);

    public abstract void do_receive_exception(ClientRequestInfo var1) throws ForwardRequest;

    public abstract void do_receive_other(ClientRequestInfo var1) throws ForwardRequest;
}

