/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Factories;

public class TransportManager
implements Configurable {
    private SocketFactory socket_factory = null;
    private SocketFactory ssl_socket_factory = null;
    private ORB orb = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private List factoryClassNames = null;
    private ProfileSelector profileSelector = null;
    private SocketFactoryManager socketFactoryManager = null;
    private Map factoriesMap = null;
    private List factoriesList = null;
    static /* synthetic */ Class class$org$jacorb$orb$ORB;

    public TransportManager(ORB orb) {
        this.orb = orb;
        this.socketFactoryManager = new SocketFactoryManager(orb);
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.giop");
        this.socketFactoryManager.configure(this.configuration);
        this.factoryClassNames = this.configuration.getAttributeList("jacorb.transport.factories");
        if (this.factoryClassNames.isEmpty()) {
            this.factoryClassNames.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        this.profileSelector = (ProfileSelector)this.configuration.getAttributeAsObject("jacorb.transport.client.selector");
        if (this.profileSelector == null) {
            this.profileSelector = new DefaultProfileSelector();
        }
        if (this.configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on")) {
            String s = this.configuration.getAttribute("jacorb.ssl.socket_factory", "");
            if (s.length() == 0) {
                throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class ssl = ObjectUtil.classForName(s);
                Constructor constr = ssl.getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = TransportManager.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                this.ssl_socket_factory = (SocketFactory)constr.newInstance(this.orb);
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(e.getMessage());
                }
                throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instantiated (" + e.getMessage() + ")!");
            }
        }
        this.socket_factory = this.socketFactoryManager.getSocketFactory();
    }

    public ProfileSelector getProfileSelector() {
        return this.profileSelector;
    }

    public SocketFactoryManager getSocketFactoryManager() {
        return this.socketFactoryManager;
    }

    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    public SocketFactory getSSLSocketFactory() {
        return this.ssl_socket_factory;
    }

    public synchronized Factories getFactories(int tag) {
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return (Factories)this.factoriesMap.get(new Integer(tag));
    }

    public synchronized List getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    private void loadFactories() {
        if (this.configuration == null) {
            throw new BAD_INV_ORDER("TransportManager not configured!");
        }
        if (this.factoryClassNames == null) {
            throw new INTERNAL("factoryClassNames should not be null");
        }
        this.factoriesMap = new HashMap();
        this.factoriesList = new ArrayList();
        Iterator i = this.factoryClassNames.iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            Factories f = this.instantiateFactories(className);
            this.factoriesMap.put(new Integer(f.profile_tag()), f);
            this.factoriesList.add(f);
        }
    }

    private Factories instantiateFactories(String className) {
        try {
            Class c = ObjectUtil.classForName(className);
            Configurable configurable = (Configurable)c.newInstance();
            configurable.configure((Configuration)this.configuration);
            return (Factories)configurable;
        }
        catch (Exception e) {
            throw new RuntimeException("could not instantiate Factories class " + className + ", exception: " + e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

