/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImplMBean;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierHelper;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.TimeBase.TimeTHelper;

public class SequenceProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements SequenceProxyPushSupplierOperations,
SequenceProxyPushSupplierImplMBean {
    private final PushTaskExecutor.PushTask flushPendingData_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            SequenceProxyPushSupplierImpl.this.deliverPendingMessages(true);
        }

        public void cancel() {
        }
    };
    private final Runnable scheduleFlushPendingData_;
    private SequencePushConsumer sequencePushConsumer_;
    private ScheduledFuture taskId_;
    private final AtomicInteger maxBatchSize_ = new AtomicInteger(1);
    private final AtomicLong pacingInterval_ = new AtomicLong(0L);
    private long timeSpent_ = 0L;

    public SequenceProxyPushSupplierImpl(IAdmin admin, ORB orb, POA poa, Configuration config, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(admin, orb, poa, config, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
        this.configureMaxBatchSize();
        this.configurePacingInterval();
        this.scheduleFlushPendingData_ = new Runnable(){

            public void run() {
                if (!SequenceProxyPushSupplierImpl.this.isDestroyed() && !SequenceProxyPushSupplierImpl.this.isSuspended() && SequenceProxyPushSupplierImpl.this.isEnabled()) {
                    SequenceProxyPushSupplierImpl.this.schedulePush(SequenceProxyPushSupplierImpl.this.flushPendingData_);
                }
            }
        };
        this.qosSettings_.addPropertySetListener("MaximumBatchSize", (PropertySetListener)new PropertySetAdapter(){

            public void actionPropertySetChanged(PropertySet source) {
                SequenceProxyPushSupplierImpl.this.configureMaxBatchSize();
            }
        });
        this.qosSettings_.addPropertySetListener("PacingInterval", (PropertySetListener)new PropertySetAdapter(){

            public void actionPropertySetChanged(PropertySet source) {
                SequenceProxyPushSupplierImpl.this.configurePacingInterval();
            }
        });
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_SEQUENCE;
    }

    public void pushPendingData() {
        this.deliverPendingMessages(false);
    }

    public void deliverPendingMessages(boolean flush) {
        Message[] _messages = flush ? this.getAllMessages() : this.getAtLeastMessages(this.maxBatchSize_.get());
        if (_messages != null && _messages.length > 0) {
            StructuredEvent[] _structuredEvents = new StructuredEvent[_messages.length];
            for (int x = 0; x < _messages.length; ++x) {
                _structuredEvents[x] = _messages[x].toStructuredEvent();
                _messages[x].dispose();
            }
            try {
                this.deliverPendingMessagesInternal(_structuredEvents);
            }
            catch (Exception e) {
                PushSequenceOperation _failedOperation = new PushSequenceOperation(_structuredEvents);
                this.handleFailedPushOperation(_failedOperation, e);
            }
        }
    }

    void deliverPendingMessagesInternal(StructuredEvent[] structuredEvents) throws Disconnected {
        long now = System.currentTimeMillis();
        this.sequencePushConsumer_.push_structured_events(structuredEvents);
        this.timeSpent_ += System.currentTimeMillis() - now;
        this.resetErrorCounter();
    }

    public void connect_sequence_push_consumer(SequencePushConsumer consumer) throws AlreadyConnected, TypeError {
        this.logger_.debug("connect_sequence_push_consumer");
        this.checkIsNotConnected();
        this.sequencePushConsumer_ = consumer;
        this.connectClient(consumer);
        this.startCronJob();
    }

    protected void connectionResumed() {
        this.schedulePush();
        this.startCronJob();
    }

    protected void connectionSuspended() {
        this.stopCronJob();
    }

    public void disconnect_sequence_push_supplier() {
        this.destroy();
    }

    protected void disconnectClient() {
        this.stopCronJob();
        this.sequencePushConsumer_.disconnect_sequence_push_consumer();
        this.sequencePushConsumer_ = null;
    }

    private void startCronJob() {
        if (this.pacingInterval_.get() > 0L && this.taskId_ == null) {
            long _interval = this.timeT2millis();
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(_interval, this.scheduleFlushPendingData_, true);
        }
    }

    public long timeT2millis() {
        long timeT = this.pacingInterval_.get();
        return SequenceProxyPushSupplierImpl.time2millis(timeT);
    }

    public static long time2millis(long timeT) {
        return timeT / 10000L;
    }

    private synchronized void stopCronJob() {
        if (this.taskId_ != null) {
            this.taskId_.cancel(true);
            this.taskId_ = null;
        }
    }

    private void checkCronJob() {
        if (this.getConnected() && this.pacingInterval_.get() > 0L) {
            this.stopCronJob();
            this.startCronJob();
        } else {
            this.stopCronJob();
        }
    }

    private boolean configurePacingInterval() {
        if (this.qosSettings_.containsKey("PacingInterval")) {
            long _pacingInterval = TimeTHelper.extract(this.qosSettings_.get("PacingInterval"));
            if (this.pacingInterval_.get() != _pacingInterval) {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("set PacingInterval=" + _pacingInterval);
                }
                this.pacingInterval_.set(_pacingInterval);
                this.checkCronJob();
                return true;
            }
        }
        return false;
    }

    private boolean configureMaxBatchSize() {
        if (this.qosSettings_.containsKey("MaximumBatchSize")) {
            int _maxBatchSize = this.qosSettings_.get("MaximumBatchSize").extract_long();
            if (this.maxBatchSize_.get() != _maxBatchSize) {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("set MaxBatchSize=" + _maxBatchSize);
                }
                this.maxBatchSize_.set(_maxBatchSize);
                return true;
            }
        }
        return false;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new SequenceProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    public Object activate() {
        return SequenceProxyPushSupplierHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    private class PushSequenceOperation
    implements PushOperation {
        private final StructuredEvent[] structuredEvents_;

        public PushSequenceOperation(StructuredEvent[] structuredEvents) {
            this.structuredEvents_ = structuredEvents;
        }

        public void invokePush() throws Disconnected {
            SequenceProxyPushSupplierImpl.this.deliverPendingMessagesInternal(this.structuredEvents_);
        }

        public void dispose() {
        }
    }
}

