/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import edu.emory.mathcs.backport.java.util.PriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.HeapEntry;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedDeadlineEventQueue
extends AbstractBoundedEventQueue {
    private final PriorityQueue heap_;
    private long counter_ = 0L;

    public BoundedDeadlineEventQueue(int maxSize, EventQueueOverflowStrategy overflowStrategy) {
        super(maxSize, overflowStrategy, new Object());
        this.heap_ = new PriorityQueue(maxSize, QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
    }

    public String getOrderPolicyName() {
        return "DeadlineOrder";
    }

    protected Message getNextElement() {
        return this.getEarliestTimeout();
    }

    protected Message getOldestElement() {
        return this.removeFirstElement(QueueUtil.ASCENDING_AGE_COMPARATOR);
    }

    private Message removeFirstElement(Comparator comp) {
        List _entries = this.copyAllEntries();
        Collections.sort(_entries, comp);
        HeapEntry _entry = (HeapEntry)_entries.get(0);
        this.heap_.remove((Object)_entry);
        return _entry.event_;
    }

    protected Message getYoungestElement() {
        return this.removeFirstElement(QueueUtil.DESCENDING_AGE_COMPARATOR);
    }

    protected Message getEarliestTimeout() {
        return ((HeapEntry)this.heap_.remove()).event_;
    }

    protected Message getLeastPriority() {
        return this.removeFirstElement(QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
    }

    protected Message[] getElements(int max) {
        Object _element;
        ArrayList<Message> _events = new ArrayList<Message>();
        while (_events.size() < max && (_element = this.heap_.remove()) != null) {
            _events.add(((HeapEntry)_element).event_);
        }
        return _events.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
    }

    protected void addElement(Message event) {
        this.heap_.add((Object)new HeapEntry(event, this.counter_++));
    }

    private List copyAllEntries() {
        ArrayList _events = new ArrayList(this.heap_.size());
        _events.addAll(this.heap_);
        return _events;
    }

    private List removeAllEntries() {
        List _entries = this.copyAllEntries();
        this.heap_.clear();
        return _entries;
    }

    protected Message[] getAllElements() {
        List _all = this.removeAllEntries();
        Message[] _ret = new Message[_all.size()];
        Iterator i = _all.iterator();
        int x = 0;
        while (i.hasNext()) {
            HeapEntry e = (HeapEntry)i.next();
            _ret[x++] = e.event_;
        }
        return _ret;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.heap_.size();
    }
}

