/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.MessageQueue;

public abstract class AbstractBoundedEventQueue
implements MessageQueue {
    private final Object lock_;
    private final int capacity_;
    private final List listeners_ = new ArrayList();
    private final EventQueueOverflowStrategy overflowStrategy_;

    protected AbstractBoundedEventQueue(int capacity, EventQueueOverflowStrategy overflowStrategy, Object lock) {
        this.lock_ = lock;
        this.capacity_ = capacity;
        this.overflowStrategy_ = overflowStrategy;
    }

    public final String getDiscardPolicyName() {
        return this.overflowStrategy_.getDiscardPolicyName();
    }

    protected abstract Message getEarliestTimeout();

    protected abstract Message getLeastPriority();

    protected abstract Message getNextElement();

    protected abstract Message getOldestElement();

    protected abstract Message getYoungestElement();

    protected abstract Message[] getElements(int var1);

    protected abstract void addElement(Message var1);

    protected abstract Message[] getAllElements();

    public abstract String getOrderPolicyName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getAllMessages(boolean wait) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            if (wait) {
                return this.getAllBlocking();
            }
            return this.getAllElements();
        }
    }

    private Message[] getAllBlocking() throws InterruptedException {
        while (this.isEmpty()) {
            this.lock_.wait();
        }
        return this.getAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(boolean wait) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            if (wait) {
                return this.getEventBlocking();
            }
            if (this.isEmpty()) {
                return null;
            }
            return this.getNextElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getMessages(int max, boolean wait) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            if (wait) {
                return this.getEventsBlocking(max);
            }
            return this.getElements(max);
        }
    }

    private Message[] getEventsBlocking(int max) throws InterruptedException {
        while (this.isEmpty()) {
            this.lock_.wait();
        }
        return this.getElements(max);
    }

    private Message getEventBlocking() throws InterruptedException {
        while (this.isEmpty()) {
            this.lock_.wait();
        }
        return this.getOldestElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Message event) {
        Object object = this.lock_;
        synchronized (object) {
            while (this.getSize() >= this.capacity_) {
                this.overflowStrategy_.removeElementFromQueue(this);
                this.fireMessageDiscarded();
            }
            this.addElement(event);
            this.lock_.notifyAll();
        }
    }

    private void fireMessageDiscarded() {
        Iterator i = this.listeners_.iterator();
        while (i.hasNext()) {
            ((MessageQueue.DiscardListener)i.next()).messageDiscarded(this.capacity_);
        }
    }

    public void addDiscardListener(MessageQueue.DiscardListener listener) {
        this.listeners_.add(listener);
    }

    public void removeDiscardListener(MessageQueue.DiscardListener listener) {
        this.listeners_.remove(listener);
    }
}

