/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.impl;

import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.AnyMessage;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.StructuredEventMessage;
import org.jacorb.notification.TypedEventMessage;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.IProxyConsumer;
import org.jacorb.notification.util.AbstractObjectPool;
import org.jacorb.notification.util.AbstractPoolablePool;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;

public class DefaultMessageFactory
implements Disposable,
MessageFactory {
    private final AbstractObjectPool typedEventMessagePool_ = new AbstractPoolablePool("TypedEventMessagePool"){

        public Object newInstance() {
            return new TypedEventMessage();
        }
    };
    private final AbstractObjectPool anyMessagePool_ = new AbstractPoolablePool("AnyMessagePool"){

        public Object newInstance() {
            return new AnyMessage();
        }
    };
    private final AbstractObjectPool structuredEventMessagePool_ = new AbstractPoolablePool("StructuredEventMessagePool"){

        public Object newInstance() {
            return new StructuredEventMessage();
        }
    };

    public DefaultMessageFactory(Configuration conf) {
        this.anyMessagePool_.configure(conf);
        this.structuredEventMessagePool_.configure(conf);
        this.typedEventMessagePool_.configure(conf);
    }

    public void dispose() {
        this.structuredEventMessagePool_.dispose();
        this.anyMessagePool_.dispose();
        this.typedEventMessagePool_.dispose();
    }

    public Message newMessage(Any any, IProxyConsumer consumer) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any), consumer);
        }
        AnyMessage _mesg = this.newAnyMessage(any);
        _mesg.setFilterStage(consumer.getFirstStage());
        return _mesg.getHandle();
    }

    public Message newMessage(StructuredEvent structuredEvent, IProxyConsumer consumer) {
        String _typeName = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(_typeName)) {
            return this.newMessage(structuredEvent.remainder_of_body, consumer);
        }
        StructuredEventMessage _mesg = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        _mesg.setFilterStage(consumer.getFirstStage());
        _mesg.setStructuredEvent(structuredEvent, consumer.getStartTimeSupported(), consumer.getStopTimeSupported());
        return _mesg.getHandle();
    }

    public Message newMessage(String interfaceName, String operationName, NVList args, IProxyConsumer consumer) {
        try {
            TypedEventMessage _mesg = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
            Property[] _props = new Property[args.count()];
            for (int x = 0; x < _props.length; ++x) {
                NamedValue _nv = args.item(x);
                _props[x] = new Property(_nv.name(), _nv.value());
            }
            _mesg.setTypedEvent(interfaceName, operationName, _props);
            _mesg.setFilterStage(consumer.getFirstStage());
            return _mesg.getHandle();
        }
        catch (Bounds e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Message newMessage(Property[] props) {
        TypedEventMessage _mesg = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
        _mesg.setTypedEvent(props);
        return _mesg.getHandle();
    }

    public Message newMessage(Any any) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any));
        }
        AnyMessage _mesg = this.newAnyMessage(any);
        return _mesg.getHandle();
    }

    private AnyMessage newAnyMessage(Any any) {
        AnyMessage _mesg = (AnyMessage)this.anyMessagePool_.lendObject();
        _mesg.setAny(any);
        return _mesg;
    }

    public Message newMessage(StructuredEvent structuredEvent) {
        String _typeName = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(_typeName)) {
            return this.newMessage(structuredEvent.remainder_of_body);
        }
        StructuredEventMessage _mesg = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        _mesg.setStructuredEvent(structuredEvent, false, false);
        return _mesg.getHandle();
    }
}

