/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.filter.ParseException;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.StaticTypeChecker;
import org.jacorb.notification.filter.etcl.StaticTypeException;
import org.jacorb.notification.filter.etcl.TCLCleanUp;
import org.jacorb.notification.filter.etcl.TCLParser;
import org.jacorb.notification.interfaces.Message;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.InvalidConstraint;

public class ETCLFilterConstraint
implements FilterConstraint {
    private final AbstractTCLNode rootNode_;

    public ETCLFilterConstraint(AbstractTCLNode root) {
        this.rootNode_ = root;
    }

    public ETCLFilterConstraint(ConstraintExp constraintExp) throws InvalidConstraint {
        try {
            this.rootNode_ = TCLParser.parse(constraintExp.constraint_expr);
            if (this.rootNode_ != null) {
                TCLCleanUp _cleanUp = new TCLCleanUp();
                _cleanUp.fix(this.rootNode_);
                StaticTypeChecker _checker = new StaticTypeChecker();
                _checker.check(this.rootNode_);
            }
            return;
        }
        catch (StaticTypeException e) {
            throw new InvalidConstraint(e.getMessage(), constraintExp);
        }
        catch (ParseException e) {
            throw new InvalidConstraint(e.getMessage(), constraintExp);
        }
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext, Message event) throws EvaluationException {
        if (this.rootNode_ == null) {
            return EvaluationResult.BOOL_TRUE;
        }
        evaluationContext.setCurrentMessage(event);
        EvaluationResult _res = this.rootNode_.evaluate(evaluationContext);
        return _res;
    }

    public String toString() {
        StringBuffer _buffer = new StringBuffer("<FilterConstraint: ");
        this.rootNode_.printToStringBuffer(_buffer);
        _buffer.append(" >");
        return _buffer.toString();
    }
}

