/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.util.ImRManager;
import org.jacorb.naming.NamingContextImpl;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer._ServantActivatorLocalBase;

public class NameServer {
    private static ORB orb = null;
    private static org.jacorb.config.Configuration configuration = null;
    private static Logger logger = null;
    private static String fileName = null;
    private static String filePrefix = "_nsdb";
    private static String commandSuffix = "";
    private static int time_out = 0;
    static String name_delimiter = "/";

    public static void configure(Configuration myConfiguration) throws ConfigurationException {
        configuration = (org.jacorb.config.Configuration)myConfiguration;
        logger = configuration.getNamedLogger("jacorb.naming");
        time_out = configuration.getAttributeAsInteger("jacorb.naming.time_out", 0);
        fileName = configuration.getAttribute("jacorb.naming.ior_filename", "");
        String directory = configuration.getAttribute("jacorb.naming.db_dir", "");
        if (!directory.equals("")) {
            filePrefix = directory + File.separatorChar + filePrefix;
        }
        if (configuration.getAttribute("jacorb.use_imr", "off").equals("on")) {
            String command = configuration.getAttribute("jacorb.java_exec", "") + commandSuffix;
            ImRManager.autoRegisterServer(orb, "StandardNS", command, ImRManager.getLocalHostName(), true);
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.jacorb.naming.NameServer [-Djacorb.naming.ior_filename=fname] [-Djacorb.naming.time_out=x][-Djacorb.use_imr=on/off][-Djacorb.naming.purge=on/off ]");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            commandSuffix = " org.jacorb.naming.NameServer";
            Properties argProps = ObjectUtil.argsToProps(args);
            Properties props = new Properties();
            props.put("jacorb.implname", "StandardNS");
            props.put("jacorb.orb.objectKeyMap.NameService", "StandardNS/NameServer-POA/_root");
            props.putAll((Map<?, ?>)argProps);
            orb = ORB.init(args, props);
            org.jacorb.config.Configuration config = ((org.jacorb.orb.ORB)orb).getConfiguration();
            NameServer.configure(config);
            POA rootPOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            Policy[] policies = new Policy[]{rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            POA nsPOA = rootPOA.create_POA("NameServer-POA", rootPOA.the_POAManager(), policies);
            NamingContextImpl.init(orb, rootPOA);
            NameServantActivatorImpl servantActivator = new NameServantActivatorImpl(orb);
            servantActivator.configure(config);
            nsPOA.set_servant_manager(servantActivator);
            nsPOA.the_POAManager().activate();
            for (int i = 0; i < policies.length; ++i) {
                policies[i].destroy();
            }
            byte[] oid = new String("_root").getBytes();
            try {
                Object obj = nsPOA.create_reference_with_id(oid, "IDL:omg.org/CosNaming/NamingContextExt:1.0");
                if (fileName != null && fileName.length() > 0) {
                    PrintWriter out = new PrintWriter(new FileOutputStream(fileName), true);
                    out.println(orb.object_to_string(obj));
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            if (logger.isInfoEnabled()) {
                logger.info("NS up");
            }
            if (time_out == 0) {
                orb.run();
            } else {
                Thread.sleep(time_out);
            }
            orb.shutdown(true);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            NameServer.usage();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static class NameServantActivatorImpl
    extends _ServantActivatorLocalBase {
        private ORB orb = null;
        private org.jacorb.config.Configuration configuration = null;
        private Logger logger = null;

        public NameServantActivatorImpl(ORB orb) {
            this.orb = orb;
        }

        public void configure(Configuration myConfiguration) throws ConfigurationException {
            this.configuration = (org.jacorb.config.Configuration)myConfiguration;
            this.logger = this.configuration.getNamedLogger("jacorb.naming.activator");
        }

        public Servant incarnate(byte[] oid, POA adapter) throws ForwardRequest {
            NamingContextImpl n;
            block13: {
                String oidStr = new String(oid);
                n = null;
                try {
                    File f = new File(filePrefix + oidStr);
                    if (f.exists()) {
                        FileInputStream f_in;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Reading in context state from file");
                        }
                        if ((f_in = new FileInputStream(f)).available() > 0) {
                            ObjectInputStream in = new ObjectInputStream(f_in);
                            n = (NamingContextImpl)in.readObject();
                            in.close();
                        }
                        f_in.close();
                    } else if (this.logger.isDebugEnabled()) {
                        this.logger.debug("No naming context state, starting empty");
                    }
                }
                catch (IOException io) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("File seems corrupt, starting empty");
                    }
                }
                catch (ClassNotFoundException c) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Could not read object from file, class not found!");
                    }
                    throw new RuntimeException("Could not read object from file, class not found!");
                }
                if (n == null) {
                    n = new NamingContextImpl();
                }
                n.init(adapter);
                try {
                    n.configure(this.configuration);
                }
                catch (ConfigurationException ce) {
                    if (!this.logger.isErrorEnabled()) break block13;
                    this.logger.error("ConfigurationException: " + ce.getMessage());
                }
            }
            return n;
        }

        public void etherealize(byte[] oid, POA adapter, Servant servant, boolean cleanup_in_progress, boolean remaining_activations) {
            String oidStr = new String(oid);
            try {
                File f = new File(filePrefix + oidStr);
                FileOutputStream fout = new FileOutputStream(f);
                ObjectOutputStream out = new ObjectOutputStream(fout);
                out.writeObject((NamingContextImpl)servant);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Saved state for servant " + oidStr);
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                this.logger.error("Error opening output file " + filePrefix + oidStr);
            }
        }
    }
}

