/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.SystemException;

public class ImRAccessImpl
implements ImRAccess {
    private Registration reg = null;
    private ImRInfo info = null;

    private ImRAccessImpl() {
    }

    public static ImRAccessImpl connect(ORB orb) {
        ImRAccessImpl result = new ImRAccessImpl();
        try {
            result.reg = RegistrationHelper.narrow(orb.resolve_initial_references("ImplementationRepository"));
        }
        catch (InvalidName in) {
            // empty catch block
        }
        boolean non_exist = true;
        if (result.reg != null) {
            try {
                non_exist = result.reg._non_existent();
            }
            catch (SystemException e) {
                non_exist = true;
            }
        }
        if (non_exist) {
            throw new INTERNAL("Unable to resolve reference to ImR");
        }
        return result;
    }

    public ProtocolAddressBase getImRAddress() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return new IIOPAddress(this.info.host, this.info.port);
    }

    public String getImRHost() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return this.info.host;
    }

    public int getImRPort() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return this.info.port;
    }

    public void registerPOA(String name, String server, ProtocolAddressBase address) throws INTERNAL {
        if (!(address instanceof IIOPAddress)) {
            throw new INTERNAL("IMR only supports IIOP based POAs");
        }
        this.registerPOA(name, server, ((IIOPAddress)address).getHostname(), ((IIOPAddress)address).getPort());
    }

    public void registerPOA(String name, String server, String host, int port) throws INTERNAL {
        try {
            this.reg.register_poa(name, server, host, port);
        }
        catch (DuplicatePOAName e) {
            throw new INTERNAL("A server with the same combination of ImplName/POA-Name (" + name + ") is already registered and listed as active at the imr!");
        }
        catch (IllegalPOAName e) {
            throw new INTERNAL("The ImR replied that the POA name >>" + e.name + "<< is illegal!");
        }
        catch (UnknownServerName e) {
            throw new INTERNAL("The ImR replied that the server name >>" + e.name + "<< is unknown!");
        }
    }

    public void setServerDown(String name) throws INTERNAL {
        try {
            this.reg.set_server_down(name);
        }
        catch (UnknownServerName e) {
            throw new INTERNAL("The ImR replied that a server with name " + name + " is unknown");
        }
    }
}

