/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class QueueSessionTest
extends PTPTestCase {
    static /* synthetic */ Class class$org$objectweb$jtests$jms$conform$session$QueueSessionTest;

    public void testRollbackRececeivedMessage() {
        try {
            this.senderConnection.stop();
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            QueueSessionTest.assertEquals((boolean)true, (boolean)this.senderSession.getTransacted());
            this.sender = this.senderSession.createSender(this.senderQueue);
            this.senderConnection.start();
            this.receiverConnection.stop();
            this.receiverSession = this.receiverConnection.createQueueSession(true, 0);
            QueueSessionTest.assertEquals((boolean)true, (boolean)this.receiverSession.getTransacted());
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            this.receiverConnection.start();
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testRollbackRececeivedMessage");
            this.sender.send((Message)message);
            this.senderSession.commit();
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            QueueSessionTest.assertTrue((m != null ? 1 : 0) != 0);
            QueueSessionTest.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            QueueSessionTest.assertEquals((String)"testRollbackRececeivedMessage", (String)msg.getText());
            QueueSessionTest.assertEquals((boolean)false, (boolean)msg.getJMSRedelivered());
            this.receiverSession.rollback();
            m = this.receiver.receive(TestConfig.TIMEOUT);
            QueueSessionTest.assertTrue((m != null ? 1 : 0) != 0);
            QueueSessionTest.assertTrue((boolean)(m instanceof TextMessage));
            msg = (TextMessage)m;
            QueueSessionTest.assertEquals((String)"testRollbackRececeivedMessage", (String)msg.getText());
            QueueSessionTest.assertEquals((boolean)true, (boolean)msg.getJMSRedelivered());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testCreateBrowser_2() {
        try {
            this.senderSession.createBrowser(this.senderQueue, "definitely not a message selector!");
            QueueSessionTest.fail((String)"Should throw a javax.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException e) {
        }
        catch (JMSException e) {
            QueueSessionTest.fail((String)("Should throw a javax.jms.InvalidSelectorException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateBrowser_1() {
        try {
            this.senderSession.createBrowser((Queue)null);
            QueueSessionTest.fail((String)"Should throw a javax.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException e) {
        }
        catch (JMSException e) {
            QueueSessionTest.fail((String)("Should throw a javax.jms.InvalidDestinationException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateReceiver_2() {
        try {
            this.receiver = this.senderSession.createReceiver(this.senderQueue, "definitely not a message selector!");
            QueueSessionTest.fail((String)"Should throw a javax.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException e) {
        }
        catch (JMSException e) {
            QueueSessionTest.fail((String)("Should throw a javax.jms.InvalidSelectorException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateReceiver_1() {
        try {
            this.receiver = this.senderSession.createReceiver((Queue)null);
            QueueSessionTest.fail((String)"Should throw a javax.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException e) {
        }
        catch (JMSException e) {
            QueueSessionTest.fail((String)("Should throw a javax.jms.InvalidDestinationException, not a " + (Object)((Object)e)));
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$objectweb$jtests$jms$conform$session$QueueSessionTest == null ? (class$org$objectweb$jtests$jms$conform$session$QueueSessionTest = QueueSessionTest.class$("org.objectweb.jtests.jms.conform.session.QueueSessionTest")) : class$org$objectweb$jtests$jms$conform$session$QueueSessionTest);
    }

    public QueueSessionTest(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

