/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class MessageBodyTest
extends PTPTestCase {
    static /* synthetic */ Class class$org$objectweb$jtests$jms$conform$message$MessageBodyTest;

    public void testClearBody_2() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("prop", "foo");
            message.clearBody();
            MessageBodyTest.assertEquals((String)"\ufffd3.11.1 Clearing a message's body does not clear its property entries.\n", (String)"foo", (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testClearBody_1() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("bar");
            message.clearBody();
            MessageBodyTest.assertEquals((String)"\ufffd3 .11.1 the clearBody method of Message resets the value of the message body to the 'empty' initial message value as set by the message type's create method provided by Session.\n", null, (String)message.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testWriteOnReceivedBody() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("foo");
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            MessageBodyTest.assertTrue((String)"The message should be an instance of TextMessage.\n", (boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            msg.setText("bar");
            MessageBodyTest.fail((String)"should raise a MessageNotWriteableException (\ufffd3.11.2)");
        }
        catch (MessageNotWriteableException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$objectweb$jtests$jms$conform$message$MessageBodyTest == null ? (class$org$objectweb$jtests$jms$conform$message$MessageBodyTest = MessageBodyTest.class$("org.objectweb.jtests.jms.conform.message.MessageBodyTest")) : class$org$objectweb$jtests$jms$conform$message$MessageBodyTest);
    }

    public MessageBodyTest(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

