/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wspolicy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.wspolicy.PolicyAlternative;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy {
    public static final String URI_POLICY = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String URI_SECURITY_UTILITY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private String targetNamespace;
    private String baseURI;
    private String id;
    private Collection<PolicyAlternative> alternatives = new ArrayList<PolicyAlternative>();
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();

    Policy() {
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.nsRegistry;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void addPolicyAlternative(PolicyAlternative polAlternative) {
        this.alternatives.add(polAlternative);
    }

    public Collection<PolicyAlternative> getPolicyAlternatives() {
        return new ArrayList<PolicyAlternative>(this.alternatives);
    }

    public Element toElement() {
        String xmlString = this.toXMLString(false);
        try {
            return DOMUtils.parse((String)xmlString);
        }
        catch (IOException ex) {
            throw new WSException(new StringBuffer().append("Cannot parse: ").append(xmlString).toString(), ex);
        }
    }

    public String toXMLString(boolean pretty) {
        if (pretty) {
            Element elPolicy = this.toElement();
            return DOMWriter.printNode((Node)elPolicy, (boolean)true);
        }
        StringBuffer xmlBuffer = new StringBuffer("<wsp:Policy");
        Iterator it = this.nsRegistry.getRegisteredURIs();
        while (it.hasNext()) {
            String nsURI = (String)it.next();
            String prefix = this.nsRegistry.getPrefix(nsURI);
            xmlBuffer.append(new StringBuffer().append(" xmlns:").append(prefix).append("='").append(nsURI).append("'").toString());
        }
        if (this.id != null) {
            xmlBuffer.append(" xmlns:wsu='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'");
            xmlBuffer.append(new StringBuffer().append(" wsu:Id='").append(this.id).append("'").toString());
        }
        if (this.baseURI != null) {
            xmlBuffer.append(new StringBuffer().append(" xml:base='").append(this.baseURI).append("'").toString());
        }
        if (this.targetNamespace != null) {
            xmlBuffer.append(new StringBuffer().append(" TargetNamespace='").append(this.targetNamespace).append("'").toString());
        }
        xmlBuffer.append(">");
        xmlBuffer.append("<wsp:ExactlyOne>");
        for (PolicyAlternative polAlternative : this.alternatives) {
            xmlBuffer.append(polAlternative.toXMLString(false));
        }
        xmlBuffer.append("</wsp:ExactlyOne>");
        xmlBuffer.append("</wsp:Policy>");
        String xmlString = xmlBuffer.toString();
        return xmlString;
    }

    public String toString() {
        return this.toXMLString(true);
    }
}

