/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.lang.reflect.Field;
import javax.xml.rpc.holders.Holder;
import org.jboss.logging.Logger;
import org.jboss.ws.utils.JavaUtils;

public class HolderUtils {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.utils.HolderUtils"));

    public static boolean isHolderType(Class javaType) {
        if (javaType == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        return Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(javaType);
    }

    public static Holder getHolderInstance(Class holderType) {
        try {
            return (Holder)holderType.newInstance();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instanciate holder: " + holderType);
        }
    }

    public static Class getHolderType(Class valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        if (Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("Is already a holder: " + valueType.getName());
        }
        if (valueType == Class.forName("java.math.BigDecimal")) {
            return Class.forName("javax.xml.rpc.holders.BigDecimalHolder");
        }
        if (valueType == Class.forName("java.math.BigInteger")) {
            return Class.forName("javax.xml.rpc.holders.BigIntegerHolder");
        }
        if (valueType == Boolean.TYPE) {
            return Class.forName("javax.xml.rpc.holders.BooleanHolder");
        }
        if (valueType == Class.forName("java.lang.Boolean")) {
            return Class.forName("javax.xml.rpc.holders.BooleanWrapperHolder");
        }
        if (valueType == Class.forName("[B")) {
            return Class.forName("javax.xml.rpc.holders.ByteArrayHolder");
        }
        if (valueType == Byte.TYPE) {
            return Class.forName("javax.xml.rpc.holders.ByteHolder");
        }
        if (valueType == Class.forName("java.lang.Byte")) {
            return Class.forName("javax.xml.rpc.holders.ByteWrapperHolder");
        }
        if (valueType == Class.forName("java.util.Calendar")) {
            return Class.forName("javax.xml.rpc.holders.CalendarHolder");
        }
        if (valueType == Double.TYPE) {
            return Class.forName("javax.xml.rpc.holders.DoubleHolder");
        }
        if (valueType == Class.forName("java.lang.Double")) {
            return Class.forName("javax.xml.rpc.holders.DoubleWrapperHolder");
        }
        if (valueType == Float.TYPE) {
            return Class.forName("javax.xml.rpc.holders.FloatHolder");
        }
        if (valueType == Class.forName("java.lang.Float")) {
            return Class.forName("javax.xml.rpc.holders.FloatWrapperHolder");
        }
        if (valueType == Integer.TYPE) {
            return Class.forName("javax.xml.rpc.holders.IntHolder");
        }
        if (valueType == Class.forName("java.lang.Integer")) {
            return Class.forName("javax.xml.rpc.holders.IntegerWrapperHolder");
        }
        if (valueType == Long.TYPE) {
            return Class.forName("javax.xml.rpc.holders.LongHolder");
        }
        if (valueType == Class.forName("java.lang.Long")) {
            return Class.forName("javax.xml.rpc.holders.LongWrapperHolder");
        }
        if (valueType == Class.forName("javax.xml.namespace.QName")) {
            return Class.forName("javax.xml.rpc.holders.QNameHolder");
        }
        if (valueType == Short.TYPE) {
            return Class.forName("javax.xml.rpc.holders.ShortHolder");
        }
        if (valueType == Class.forName("java.lang.Short")) {
            return Class.forName("javax.xml.rpc.holders.ShortWrapperHolder");
        }
        if (valueType == Class.forName("java.lang.String")) {
            return Class.forName("javax.xml.rpc.holders.StringHolder");
        }
        if (valueType == Class.forName("java.lang.Object")) {
            return Class.forName("javax.xml.rpc.holders.ObjectHolder");
        }
        log.warn((Object)("Cannot get holder type for: " + valueType));
        return null;
    }

    public static Class getValueType(Class holderType) {
        Field field;
        if (holderType == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        if (!Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(holderType)) {
            throw new IllegalArgumentException("Is not a holder: " + holderType.getName());
        }
        try {
            field = holderType.getField("value");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Cannot find public value field: " + holderType);
        }
        return field.getType();
    }

    public static Object getHolderValue(Object holder) {
        if (holder == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        if (!Class.forName("javax.xml.rpc.holders.Holder").isInstance(holder)) {
            throw new IllegalArgumentException("Is not a holder: " + holder);
        }
        try {
            Field valueField = holder.getClass().getField("value");
            Object obj = valueField.get(holder);
            return obj;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access public value field: " + holder);
        }
    }

    public static void setHolderValue(Object holder, Object value) {
        if (holder == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        if (!Class.forName("javax.xml.rpc.holders.Holder").isInstance(holder)) {
            throw new IllegalArgumentException("Is not a holder: " + holder);
        }
        Class valueType = HolderUtils.getValueType(holder.getClass());
        value = JavaUtils.isPrimitive(valueType) ? JavaUtils.getPrimitiveValue(value) : JavaUtils.getWrapperValue(value);
        if (value != null && !JavaUtils.isAssignableFrom(valueType, value.getClass())) {
            throw new IllegalArgumentException("Holder [" + holder.getClass().getName() + "] value not assignable: " + value);
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (value != null || !valueType.isPrimitive()) {
                valueField.set(holder, value);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access public value field: " + holder);
        }
    }
}

