/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import edu.emory.mathcs.backport.java.util.LinkedList;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import org.jboss.ws.WSException;
import org.jboss.ws.soap.attachment.AttachmentPartImpl;
import org.jboss.ws.soap.attachment.BoundaryDelimitedInputStream;
import org.jboss.ws.soap.attachment.SwapableMemoryDataSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRelatedDecoder {
    private ContentType contentType;
    private String rootType;
    private AttachmentPartImpl rootPart;
    private java.util.LinkedList<AttachmentPart> relatedParts = new LinkedList();

    public MultipartRelatedDecoder(ContentType contentType) throws IOException, MessagingException {
        this.contentType = contentType;
        if (!contentType.getBaseType().equals("multipart/related")) {
            throw new IllegalArgumentException("Multipart related decoder called with a non-multipart/related type");
        }
        this.rootType = contentType.getParameter("type");
        if (this.rootType == null) {
            throw new IllegalArgumentException("multipart/related type is invalid, it is missing the root type parameter");
        }
    }

    private boolean isValidRootType(String type) throws ParseException {
        ContentType contentType = new ContentType(type);
        type = contentType.getBaseType();
        return this.rootType.equals(type);
    }

    public void decodeMultipartRelatedMessage(InputStream stream) throws IOException, MessagingException {
        byte[] boundary;
        String boundaryParameter = this.contentType.getParameter("boundary");
        String start = this.contentType.getParameter("start");
        if (boundaryParameter == null) {
            throw new IllegalArgumentException("multipart/related content type did not contain a boundary");
        }
        try {
            boundary = new StringBuffer().append("\r\n--").append(boundaryParameter).toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new WSException("US-ASCII not supported, this should never happen");
        }
        BoundaryDelimitedInputStream delimitedStream = new BoundaryDelimitedInputStream(stream, boundary);
        byte[] buffer = new byte[256];
        while (delimitedStream.read(buffer) != -1) {
        }
        while (!delimitedStream.isOuterStreamClosed()) {
            if (!this.advanceToHeaders(delimitedStream)) continue;
            InternetHeaders headers = new InternetHeaders((InputStream)delimitedStream);
            String[] typeHeader = headers.getHeader("Content-Type");
            if (typeHeader == null) {
                throw new IllegalArgumentException("multipart/related stream invalid, component Content-type missing.");
            }
            SwapableMemoryDataSource source = new SwapableMemoryDataSource(delimitedStream, typeHeader[0]);
            AttachmentPartImpl part = new AttachmentPartImpl(new DataHandler((DataSource)source));
            Enumeration enumeration = headers.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                part.addMimeHeader(header.getName(), header.getValue());
            }
            if (this.rootPart == null && (start == null || start.equals(part.getContentId()))) {
                if (!this.isValidRootType(part.getContentType())) {
                    throw new IllegalArgumentException("multipart/related type specified a root type other than the one that was found.");
                }
                this.rootPart = part;
                continue;
            }
            this.relatedParts.add((Object)part);
        }
        if (this.rootPart == null) {
            throw new IllegalArgumentException("multipart/related stream invalid, no root part was found");
        }
    }

    private boolean advanceToHeaders(InputStream stream) throws IOException {
        boolean dash = false;
        boolean cr = false;
        block6: while (true) {
            int b = stream.read();
            switch (b) {
                case -1: {
                    return false;
                }
                case 13: {
                    cr = true;
                    dash = false;
                    continue block6;
                }
                case 45: {
                    if (dash) {
                        stream.close();
                        return false;
                    }
                    dash = true;
                    cr = false;
                    continue block6;
                }
                case 10: {
                    if (cr) {
                        return true;
                    }
                    dash = false;
                    continue block6;
                }
            }
            dash = false;
            cr = false;
        }
    }

    public AttachmentPart getRootPart() {
        return this.rootPart;
    }

    public Collection<AttachmentPart> getRelatedParts() {
        return this.relatedParts;
    }
}

