/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ws.soap.attachment.SimpleBoyerMoore;

public class BoundaryDelimitedInputStream
extends FilterInputStream {
    private static final int BOUNDARY_NOT_FOUND = -1;
    private byte[] boundary;
    private SimpleBoyerMoore boyerMoore;
    private byte[] leftOvers;
    private int leftOverPosition;
    private InputStream source;
    private boolean simulateEof;
    private boolean realEof;
    private boolean bufferingCompleted;

    public BoundaryDelimitedInputStream(InputStream in, byte[] boundary) {
        super(in);
        this.source = in;
        this.boundary = (byte[])boundary.clone();
        this.boyerMoore = new SimpleBoyerMoore(this.boundary);
    }

    private void createLeftOvers(byte[] buffer, int start, int end) {
        int length = end - start;
        if (length <= 0) {
            return;
        }
        if (this.bufferingCompleted && this.leftOvers != null) {
            this.leftOverPosition -= length;
            return;
        }
        int leftOverLength = this.leftOvers == null ? 0 : this.leftOvers.length - this.leftOverPosition;
        byte[] newLeftOvers = new byte[length + leftOverLength];
        System.arraycopy(buffer, start, newLeftOvers, 0, length);
        if (this.leftOvers != null) {
            System.arraycopy(this.leftOvers, this.leftOverPosition, newLeftOvers, length, leftOverLength);
        }
        this.leftOvers = newLeftOvers;
        this.leftOverPosition = 0;
    }

    private int consumeLeftOvers(byte[] buffer, int offset, int length) {
        if (this.leftOvers == null) {
            return 0;
        }
        int i = 0;
        while (i < length && this.leftOverPosition < this.leftOvers.length) {
            buffer[offset + i++] = this.leftOvers[this.leftOverPosition++];
        }
        if (this.leftOverPosition >= this.leftOvers.length) {
            this.leftOvers = null;
            this.leftOverPosition = 0;
        }
        return i;
    }

    private int fullRead(byte[] buffer, int offset, int length) throws IOException {
        int count = 0;
        int read = 0;
        do {
            if ((read = this.source.read(buffer, offset + count, length - count)) <= 0) continue;
            count += read;
        } while (read > 0 && count < length);
        if (read < 0) {
            this.realEof = true;
        }
        return count;
    }

    private int findBoundary(byte[] buffer, int length) {
        return this.boyerMoore.patternSearch(buffer, 0, length);
    }

    private int read(byte[] b, int off, int len, boolean skip) throws IOException {
        int returnLength;
        int bufferLength;
        byte[] buffer;
        int position;
        if (len == 0) {
            return 0;
        }
        if (this.simulateEof) {
            this.simulateEof = false;
            return -1;
        }
        if (this.realEof) {
            if (this.leftOvers == null) {
                return -1;
            }
            if (!this.bufferingCompleted) {
                this.bufferingCompleted = true;
            }
        }
        if ((position = this.consumeLeftOvers(buffer = new byte[bufferLength = Math.max(this.boundary.length * 2, len + this.boundary.length)], 0, bufferLength)) < bufferLength) {
            position += this.fullRead(buffer, position, bufferLength - position);
        }
        if (this.realEof && position == 0) {
            return -1;
        }
        int boundaryPosition = this.findBoundary(buffer, position);
        if (boundaryPosition == -1 || boundaryPosition >= len) {
            returnLength = Math.min(len, position);
            this.createLeftOvers(buffer, returnLength, position);
        } else {
            returnLength = boundaryPosition;
            this.createLeftOvers(buffer, returnLength + this.boundary.length, position);
            if (returnLength == 0) {
                return -1;
            }
            this.simulateEof = true;
        }
        if (!skip) {
            System.arraycopy(buffer, 0, b, off, returnLength);
        }
        return returnLength;
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this.source.close();
        this.leftOvers = null;
        this.leftOverPosition = 0;
        this.realEof = true;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        return this.read(null, 0, (int)n, true);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len, false);
    }

    public boolean isOuterStreamClosed() {
        return this.realEof && this.leftOvers == null;
    }

    public void printLeftOvers() {
        if (this.leftOvers != null) {
            System.out.println("LEFT = " + new String(this.leftOvers, this.leftOverPosition, this.leftOvers.length - this.leftOverPosition));
        }
    }
}

