/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.soap.DetailImpl;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPFactoryImpl
extends SOAPFactory {
    private static Logger log = Logger.getLogger(Class.forName("org.jboss.ws.soap.SOAPFactoryImpl"));

    public SOAPElement createElement(Name name) throws SOAPException {
        return new SOAPElementImpl(name);
    }

    public SOAPElement createElement(String localName) throws SOAPException {
        return new SOAPElementImpl(localName);
    }

    public SOAPElement createElement(String localName, String prefix, String uri) throws SOAPException {
        return new SOAPElementImpl(localName, prefix, uri);
    }

    public SOAPElementImpl createElement(Element domNode, boolean deep) throws SOAPException {
        if (domNode == null) {
            throw new IllegalArgumentException("Source node cannot be null");
        }
        String localName = domNode.getLocalName();
        String prefix = domNode.getPrefix();
        String nsURI = domNode.getNamespaceURI();
        SOAPElementImpl soapElement = new SOAPElementImpl(localName, prefix, nsURI);
        if (deep) {
            if (domNode instanceof Element) {
                DOMUtils.copyAttributes((Element)((Object)soapElement), (Element)domNode);
            }
            NodeList nlist = domNode.getChildNodes();
            for (int i = 0; i < nlist.getLength(); ++i) {
                String nodeValue;
                Node child = nlist.item(i);
                short nodeType = child.getNodeType();
                if (nodeType == 1) {
                    SOAPElementImpl soapChild = this.createElement((Element)child, true);
                    soapElement.addChildElement(soapChild);
                    continue;
                }
                if (nodeType == 3) {
                    nodeValue = child.getNodeValue();
                    soapElement.addTextNode(nodeValue);
                    continue;
                }
                if (nodeType == 4) {
                    nodeValue = child.getNodeValue();
                    soapElement.addTextNode(nodeValue);
                    continue;
                }
                log.trace((Object)("Ignore child type: " + nodeType));
            }
        }
        return soapElement;
    }

    public Detail createDetail() throws SOAPException {
        return new DetailImpl();
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(localName, prefix, uri);
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }
}

