/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsse.Config;
import org.jboss.ws.metadata.wsse.Encrypt;
import org.jboss.ws.metadata.wsse.Operation;
import org.jboss.ws.metadata.wsse.Port;
import org.jboss.ws.metadata.wsse.RequireEncryption;
import org.jboss.ws.metadata.wsse.RequireSignature;
import org.jboss.ws.metadata.wsse.RequireTimestamp;
import org.jboss.ws.metadata.wsse.Requires;
import org.jboss.ws.metadata.wsse.Sign;
import org.jboss.ws.metadata.wsse.Target;
import org.jboss.ws.metadata.wsse.Timestamp;
import org.jboss.ws.metadata.wsse.Username;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class WSSecurityConfigurationFactory
implements ObjectModelFactory {
    public static String SERVER_RESOURCE_NAME = "jboss-wsse-server.xml";
    public static String CLIENT_RESOURCE_NAME = "jboss-wsse-client.xml";
    private static HashMap options = new HashMap(6);
    private static final Logger log;

    private WSSecurityConfigurationFactory() {
    }

    public static WSSecurityConfigurationFactory newInstance() {
        return new WSSecurityConfigurationFactory();
    }

    public WSSecurityConfiguration parse(URL configurationFile) throws IOException {
        if (configurationFile == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        InputStream is = configurationFile.openStream();
        try {
            WSSecurityConfiguration configuration;
            WSSecurityConfiguration wSSecurityConfiguration = configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(is, (ObjectModelFactory)this, null);
            return wSSecurityConfiguration;
        }
        catch (JBossXBException e) {
            IOException ioex = new IOException("Cannot parse: " + configurationFile);
            Throwable cause = e.getCause();
            if (cause != null) {
                ioex.initCause(cause);
            }
            throw ioex;
        }
        finally {
            is.close();
        }
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return new WSSecurityConfiguration();
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public void setValue(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + configuration + ",value=" + value + "]"));
        String method = (String)options.get(localName);
        if (method == null) {
            return;
        }
        try {
            Class.forName("org.jboss.ws.metadata.wsse.WSSecurityConfiguration").getMethod(method, Class.forName("java.lang.String")).invoke((Object)configuration, value);
        }
        catch (Exception e) {
            log.error((Object)("Could not set option: " + method + " to: " + value), (Throwable)e);
        }
    }

    public Object newChild(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("config".equals(localName)) {
            return new Config();
        }
        if ("port".equals(localName)) {
            return new Port(attrs.getValue("", "name"));
        }
        return null;
    }

    public void addChild(WSSecurityConfiguration configuration, Config defaultConfig, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + defaultConfig + "]"));
        configuration.setDefaultConfig(defaultConfig);
    }

    public void addChild(WSSecurityConfiguration configuration, Port port, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + configuration + ",child=" + port + "]"));
        configuration.addPort(port);
    }

    public Object newChild(Config config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("sign".equals(localName)) {
            Boolean include = new Boolean(true);
            String timestamp = attrs.getValue("", "includeTimestamp");
            if (timestamp != null) {
                include = (Boolean)SimpleTypeBindings.unmarshal((String)timestamp, (String)"boolean", null);
            }
            return new Sign(attrs.getValue("", "type"), attrs.getValue("", "alias"), include);
        }
        if ("encrypt".equals(localName)) {
            return new Encrypt(attrs.getValue("", "type"), attrs.getValue("", "alias"), attrs.getValue("", "algorithm"));
        }
        if ("timestamp".equals(localName)) {
            return new Timestamp(attrs.getValue("", "ttl"));
        }
        if ("requires".equals(localName)) {
            return new Requires();
        }
        if ("username".equals(localName)) {
            return new Username();
        }
        return null;
    }

    public void addChild(Config config, Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + encrypt + "]"));
        config.setEncrypt(encrypt);
    }

    public void addChild(Config config, Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + sign + "]"));
        config.setSign(sign);
    }

    public void addChild(Config config, Timestamp timestamp, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + timestamp + "]"));
        config.setTimestamp(timestamp);
    }

    public void addChild(Config config, Username username, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + username + "]"));
        config.setUsername(username);
    }

    public void addChild(Config config, Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + config + ",child=" + requires + "]"));
        config.setRequires(requires);
    }

    private Object handleTargets(Object object, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("target".equals(localName)) {
            Target target = new Target(attrs.getValue("", "type"));
            if ("true".equals(attrs.getValue("", "contentOnly"))) {
                target.setContentOnly(true);
            }
            return target;
        }
        return null;
    }

    public Object newChild(Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(encrypt, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(sign, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("signature".equals(localName)) {
            return new RequireSignature();
        }
        if ("encryption".equals(localName)) {
            return new RequireEncryption();
        }
        if ("timestamp".equals(localName)) {
            return new RequireTimestamp(attrs.getValue("", "maxAge"));
        }
        return null;
    }

    public Object newChild(RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(requireSignature, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.handleTargets(requireEncryption, navigator, namespaceURI, localName, attrs);
    }

    public void setValue(Target target, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace((Object)("setValue: [obj=" + target + ",value=" + value + "]"));
        target.setValue(value);
    }

    public void addChild(Encrypt encrypt, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + encrypt + ",child=" + target + "]"));
        encrypt.addTarget(target);
    }

    public void addChild(Sign sign, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + sign + ",child=" + target + "]"));
        sign.addTarget(target);
    }

    public void addChild(Requires requires, RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireEncryption + "]"));
        requires.setRequireEncryption(requireEncryption);
    }

    public void addChild(Requires requires, RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireSignature + "]"));
        requires.setRequireSignature(requireSignature);
    }

    public void addChild(Requires requires, RequireTimestamp requireTimestamp, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requires + ",child=" + requireTimestamp + "]"));
        requires.setRequireTimestamp(requireTimestamp);
    }

    public void addChild(RequireEncryption requireEncryption, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requireEncryption + ",child=" + target + "]"));
        requireEncryption.addTarget(target);
    }

    public void addChild(RequireSignature requireSignature, Target target, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + requireSignature + ",child=" + target + "]"));
        requireSignature.addTarget(target);
    }

    public Object newChild(Port port, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("operation".equals(localName)) {
            return new Operation(attrs.getValue("", "name"));
        }
        if ("config".equals(localName)) {
            return new Config();
        }
        return null;
    }

    public void addChild(Port port, Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + port + ",child=" + operation + "]"));
        port.addOperation(operation);
    }

    public void addChild(Port port, Config config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + port + ",child=" + config + "]"));
        port.setDefaultConfig(config);
    }

    public Object newChild(Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("newChild: " + localName));
        if ("config".equals(localName)) {
            return new Config();
        }
        return null;
    }

    public void addChild(Operation operation, Config config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace((Object)("addChild: [obj=" + operation + ",child=" + config + "]"));
        operation.setConfig(config);
    }

    static {
        options.put("key-store-file", "setKeyStoreFile");
        options.put("key-store-type", "setKeyStoreType");
        options.put("key-store-password", "setKeyStorePassword");
        options.put("trust-store-file", "setTrustStoreFile");
        options.put("trust-store-type", "setTrustStoreType");
        options.put("trust-store-password", "setTrustStorePassword");
        log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.wsse.WSSecurityConfigurationFactory"));
    }
}

