/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;

public class WSDLInterface
extends Extendable {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.wsdl.WSDLInterface"));
    private static final long serialVersionUID = 2453454924501233964L;
    private WSDLDefinitions wsdlDefinitions;
    private NCName name;
    private QName qname;
    private QName[] extendList;
    private String styleDefault;
    private Map operations = new LinkedHashMap();
    private Map faults = new LinkedHashMap();

    public WSDLInterface(WSDLDefinitions wsdlDefinitions) {
        log.debug((Object)"new WSDLInterface");
        this.wsdlDefinitions = wsdlDefinitions;
    }

    public WSDLInterfaceOperation getWSDLInterfaceOperation(NCName name) {
        return (WSDLInterfaceOperation)this.operations.get(name);
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public NCName getName() {
        return this.name;
    }

    public void setName(NCName name) {
        log.debug((Object)("setName: " + name));
        this.name = name;
    }

    public QName getQName() {
        if (this.qname == null) {
            String tnsURI = this.wsdlDefinitions.getTargetNamespace();
            this.qname = new QName(tnsURI, this.name.toString());
        }
        return this.qname;
    }

    public void setQName(QName qname) {
        log.debug((Object)("setQName: " + qname));
        this.qname = qname;
    }

    public QName[] getExtendList() {
        return this.extendList;
    }

    public void setExtendList(QName[] extendList) {
        this.extendList = extendList;
    }

    public String getStyleDefault() {
        return this.styleDefault;
    }

    public void setStyleDefault(String styleDefault) {
        this.styleDefault = styleDefault;
    }

    public WSDLInterfaceOperation[] getOperations() {
        WSDLInterfaceOperation[] arr = new WSDLInterfaceOperation[this.operations.size()];
        new ArrayList(this.operations.values()).toArray(arr);
        return arr;
    }

    public WSDLInterfaceOperation[] getSortedOperations() {
        Object[] arr = new WSDLInterfaceOperation[this.operations.size()];
        new ArrayList(this.operations.values()).toArray(arr);
        Arrays.sort((Object[])arr);
        return arr;
    }

    public WSDLInterfaceOperation getOperation(NCName opName) {
        WSDLInterfaceOperation operation = (WSDLInterfaceOperation)this.operations.get(opName);
        return operation;
    }

    public void addOperation(WSDLInterfaceOperation operation) {
        this.operations.put(operation.getName(), operation);
    }

    public WSDLInterfaceFault[] getFaults() {
        WSDLInterfaceFault[] arr = new WSDLInterfaceFault[this.faults.size()];
        new ArrayList(this.faults.values()).toArray(arr);
        return arr;
    }

    public WSDLInterfaceFault getFault(NCName fName) {
        WSDLInterfaceFault fault = (WSDLInterfaceFault)this.faults.get(fName);
        return fault;
    }

    public void addFault(WSDLInterfaceFault fault) {
        this.faults.put(fault.getName(), fault);
    }

    public boolean containsInterfaceOperation(NCName name) {
        return this.operations.containsKey(name);
    }
}

