/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.WSDLWriter;

public class WSDL20Writer
extends WSDLWriter {
    protected static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.wsdl.WSDL20Writer"));
    protected WSDLUtils utils = WSDLUtils.getInstance();

    public WSDL20Writer(WSDLDefinitions wsdl) {
        super(wsdl);
    }

    protected void appendInterfaces(StringBuffer buffer) {
        WSDLInterface[] interfaces = this.wsdl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            WSDLInterface intf = interfaces[i];
            buffer.append("<interface name='" + intf.getName() + "'>");
            this.appendInterfaceFaults(buffer, intf);
            this.appendInterfaceOperations(buffer, intf);
            buffer.append("</interface>");
        }
    }

    private void appendInterfaceFaults(StringBuffer buffer, WSDLInterface intf) {
        WSDLInterfaceFault[] faults = intf.getFaults();
        for (int i = 0; i < faults.length; ++i) {
            WSDLInterfaceFault fault = faults[i];
            buffer.append("<fault name='" + fault.getName() + "'");
            buffer.append(" element='" + this.getQNameRef(fault.getXmlName()) + "'>");
            if (fault.getDocumentation() != null) {
                buffer.append(fault.getDocumentation());
            }
            buffer.append("</fault>");
        }
    }

    private void appendInterfaceOperations(StringBuffer buffer, WSDLInterface intf) {
        WSDLInterfaceOperation[] operations = intf.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            WSDLInterfaceOperation operation = operations[i];
            buffer.append("<operation name='" + operation.getName() + "'>");
            WSDLInterfaceOperationInput[] inputs = operation.getInputs();
            for (int j = 0; j < inputs.length; ++j) {
                WSDLInterfaceOperationInput ip = inputs[j];
                buffer.append("<input element='" + this.getQNameRef(ip.getElement()) + "'");
                if (ip.getMessageLabel() != null) {
                    buffer.append(" messageLabel='" + ip.getMessageLabel() + "'");
                }
                buffer.append(">");
                this.appendProperties(buffer, ip.getProperties());
                buffer.append("</input>");
            }
            WSDLInterfaceOperationOutput[] outputs = operation.getOutputs();
            for (int j = 0; j < outputs.length; ++j) {
                WSDLInterfaceOperationOutput op = outputs[j];
                buffer.append("<output element='" + this.getQNameRef(op.getElement()) + "'");
                if (op.getMessageLabel() != null) {
                    buffer.append(" messageLabel='" + op.getMessageLabel() + "'");
                }
                buffer.append(">");
                this.appendProperties(buffer, op.getProperties());
                buffer.append("</output>");
            }
            WSDLInterfaceOperationOutfault[] outfaults = operation.getOutfaults();
            for (int j = 0; j < outfaults.length; ++j) {
                WSDLInterfaceOperationOutfault outfault = outfaults[j];
                buffer.append("<outfault ref='" + this.getQNameRef(outfault.getRef()) + "'>");
                if (outfault.getMessageLabel() != null) {
                    buffer.append(" messageLabel='" + outfault.getMessageLabel() + "'");
                }
                buffer.append("</outfault>");
            }
            buffer.append("</operation>");
        }
    }

    private void appendProperties(StringBuffer buffer, WSDLProperty[] wsdlProperties) {
        for (int i = 0; i < wsdlProperties.length; ++i) {
            WSDLProperty wsdlProperty = wsdlProperties[i];
            String uri = wsdlProperty.getURI();
            String value = wsdlProperty.getValue();
            buffer.append("<property uri='" + uri + "'>" + (value != null ? "<value>" + value + "</value>" : "") + "</property>");
        }
    }

    protected void appendBindings(StringBuffer buffer) {
        WSDLBinding[] bindings = this.wsdl.getBindings();
        for (int i = 0; i < bindings.length; ++i) {
            WSDLBinding binding = bindings[i];
            buffer.append("<binding name='" + binding.getName() + "'");
            if (binding.getInterfaceName() != null) {
                buffer.append(" interface='" + this.getQNameRef(binding.getInterfaceName()) + "'");
            }
            buffer.append(">");
            this.appendBindingOperations(buffer, binding);
            buffer.append("</binding>");
        }
    }

    protected void appendBindingOperations(StringBuffer buffer, WSDLBinding binding) {
        WSDLBindingOperation[] operations = binding.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            WSDLBindingOperation operation = operations[i];
            buffer.append("<operation ref='" + this.getQNameRef(operation.getRef()) + "'>");
            buffer.append("</operation>");
        }
    }

    protected void appendServices(StringBuffer buffer) {
        WSDLService[] services = this.wsdl.getServices();
        for (int i = 0; i < services.length; ++i) {
            WSDLService service = services[i];
            buffer.append("<service name='" + service.getName() + "'");
            if (service.getInterfaceName() != null) {
                buffer.append(" interface='" + this.getQNameRef(service.getInterfaceName()) + "'");
            }
            buffer.append(">");
            WSDLEndpoint[] endpoints = service.getEndpoints();
            for (int j = 0; j < endpoints.length; ++j) {
                WSDLEndpoint endpoint = endpoints[j];
                buffer.append("<endpoint name='" + endpoint.getName() + "'");
                if (endpoint.getBinding() != null) {
                    buffer.append(" binding='" + this.getQNameRef(endpoint.getBinding()) + "'");
                }
                if (endpoint.getAddress() != null) {
                    buffer.append(" address='" + endpoint.getAddress() + "'");
                }
                buffer.append("></endpoint>");
            }
            buffer.append("</service>");
        }
    }
}

