/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.encoding.JAXBDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.JAXBSerializerFactory;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.utils.JavaUtils;

public class ParameterWrapping {
    private static Logger log = Logger.getLogger(Class.forName("org.jboss.ws.jaxrpc.ParameterWrapping"));

    private static void assertOperationMetaData(OperationMetaData opMetaData) {
        if (opMetaData.getStyle() != Style.DOCUMENT) {
            throw new WSException("Unexpected style: " + opMetaData.getStyle());
        }
        if (opMetaData.getNonHeaderParameters().size() != 1) {
            throw new WSException("Unexpected number of input parameters: " + opMetaData.getParameters().size());
        }
        if (opMetaData.getReturnParameter() == null && !opMetaData.isOneWayOperation()) {
            throw new WSException("Unexpected null return parameter");
        }
        if (opMetaData.getParameterStyle() != ParameterStyle.WRAPPED) {
            throw new WSException("Unexpected parameter style: " + opMetaData.getParameterStyle());
        }
    }

    public static boolean matchRequestParameters(OperationMetaData opMetaData, Class[] paramTypes) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class reqStructType = paramMetaData.getJavaType();
        log.debug((Object)("matchRequestParameters: " + reqStructType.getName()));
        try {
            boolean pass = true;
            for (int i = 0; pass && i < varNames.size(); ++i) {
                String varName = varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getWriteMethod();
                Class<?> methodType = method.getParameterTypes()[0];
                Class paramType = paramTypes[i];
                pass = JavaUtils.isAssignableFrom(methodType, paramType);
            }
            return pass;
        }
        catch (Exception ex) {
            log.debug((Object)("Invalid request wrapper: " + ex));
            return false;
        }
    }

    public static Object wrapRequestParameters(OperationMetaData opMetaData, Object[] inParams) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class reqStructType = paramMetaData.getJavaType();
        log.debug((Object)("wrapRequestParameters: " + reqStructType.getName()));
        try {
            Object reqStruct = reqStructType.newInstance();
            for (int i = 0; i < varNames.size(); ++i) {
                String varName = varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getWriteMethod();
                Object value = inParams[i];
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                method.invoke(reqStruct, value);
            }
            return reqStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot wrap request structure: " + e);
        }
    }

    public static Object[] unwrapRequestParameters(OperationMetaData opMetaData, Object reqStruct) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        if (reqStruct == null) {
            throw new IllegalArgumentException("Request struct cannot be null");
        }
        ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class<?> reqStructType = reqStruct.getClass();
        log.debug((Object)("unwrapRequestParameters: " + reqStructType.getName()));
        Object[] inParams = new Object[varNames.size()];
        try {
            for (int i = 0; i < varNames.size(); ++i) {
                String varName = varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getReadMethod();
                Object value = method.invoke(reqStruct, new Object[0]);
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                inParams[i] = value;
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
        }
        return inParams;
    }

    public static Object wrapResponseParameter(OperationMetaData opMetaData, Object outParam) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        ParameterMetaData paramMetaData = opMetaData.getReturnParameter();
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class resStructType = paramMetaData.getJavaType();
        if (outParam != null && outParam.getClass() == resStructType) {
            log.debug((Object)("Response parameter already wrapped" + resStructType.getName()));
            return outParam;
        }
        log.debug((Object)("wrapResponseParameter: " + resStructType.getName()));
        try {
            Object resStruct = resStructType.newInstance();
            if (varNames.size() > 0) {
                String varName = varNames.get(0);
                PropertyDescriptor pd = new PropertyDescriptor(varName, resStructType);
                Method method = pd.getWriteMethod();
                Object value = outParam;
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                method.invoke(resStruct, value);
            }
            return resStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot wrap response structure: " + e);
        }
    }

    public static Object unwrapResponseParameter(OperationMetaData opMetaData, Object resStruct) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        Object retValue = null;
        if (resStruct != null) {
            ParameterMetaData paramMetaData = opMetaData.getReturnParameter();
            List<String> varNames = paramMetaData.getWrappedVariables();
            Class<?> resStructType = resStruct.getClass();
            log.debug((Object)("unwrapResponseParameter: " + resStructType.getName()));
            try {
                if (varNames.size() > 0) {
                    String varName = varNames.get(0);
                    PropertyDescriptor pd = new PropertyDescriptor(varName, resStructType);
                    Method method = pd.getReadMethod();
                    Object value = method.invoke(resStruct, new Object[0]);
                    log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                    retValue = value;
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
            }
        }
        return retValue;
    }

    public static void generateWrapper(ParameterMetaData pmd, boolean addTypeMapping) {
        Class wrapperType;
        List<String> wrappedTypes = pmd.getWrappedTypes();
        List<String> wrappedVariables = pmd.getWrappedVariables();
        OperationMetaData operationMetaData = pmd.getOperationMetaData();
        EndpointMetaData endpointMetaData = operationMetaData.getEndpointMetaData();
        ServiceMetaData serviceMetaData = endpointMetaData.getServiceMetaData();
        ClassLoader loader = serviceMetaData.getUnifiedMetaData().getClassLoader();
        if (!operationMetaData.isDocumentWrapped()) {
            throw new WSException("Operation is not document/literal (wrapped)");
        }
        if (wrappedTypes == null) {
            throw new WSException("Cannot generate a type when their is no type information");
        }
        String serviceName = serviceMetaData.getName().getLocalPart();
        String parameterName = pmd.getXmlName().getLocalPart();
        String endpointName = endpointMetaData.getName().getLocalPart();
        String packageName = endpointMetaData.getServiceEndpointInterface().getPackage().getName();
        String wrapperName = packageName + ".__JBossWS_" + serviceName + "_" + endpointName + "_" + parameterName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating wrapper: " + wrapperName));
        }
        try {
            ClassPool pool = new ClassPool(true);
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass clazz = pool.makeClass(wrapperName);
            clazz.setSuperclass(pool.get(Class.forName("org.jboss.ws.jaxrpc.ParameterWrapping$WrapperType").getName()));
            for (int i = 0; i < wrappedTypes.size(); ++i) {
                String typeName = wrappedTypes.get(i);
                String name = wrappedVariables.get(i);
                CtField field = new CtField(pool.get(typeName), name, clazz);
                field.setModifiers(2);
                clazz.addField(field);
                clazz.addMethod(CtNewMethod.getter((String)("get" + ParameterWrapping.capitalize(name)), (CtField)field));
                clazz.addMethod(CtNewMethod.setter((String)("set" + ParameterWrapping.capitalize(name)), (CtField)field));
            }
            wrapperType = pool.toClass(clazz, loader);
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + wrapperName, e);
        }
        if (addTypeMapping) {
            QName xmlType = pmd.getXmlType();
            TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, wrapperName);
            typesMetaData.addTypeMapping(tmMetaData);
            TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
            typeMapping.register(wrapperType, xmlType, new JAXBSerializerFactory(), new JAXBDeserializerFactory());
        }
        pmd.setJavaTypeName(wrapperName);
    }

    private static String capitalize(String source) {
        if (source == null) {
            return null;
        }
        if (source.length() == 0) {
            return source;
        }
        char c = Character.toUpperCase(source.charAt(0));
        return c + source.substring(1);
    }

    public static class WrapperType {
    }
}

