/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.ReferenceParameters;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.Constants;
import org.jboss.ws.eventing.EventingConstants;
import org.jboss.ws.eventing.EventingEndpointBase;
import org.jboss.ws.eventing.SubscriptionManagerEndpoint;
import org.jboss.ws.eventing.element.RenewRequest;
import org.jboss.ws.eventing.element.RenewResponse;
import org.jboss.ws.eventing.element.StatusRequest;
import org.jboss.ws.eventing.element.StatusResponse;
import org.jboss.ws.eventing.element.UnsubscribeRequest;
import org.jboss.ws.eventing.mgmt.SubscriptionError;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SubscriptionManagerEndpointImpl
extends EventingEndpointBase
implements SubscriptionManagerEndpoint {
    public static final QName IDQN = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier", "ns1");

    public StatusResponse getStatus(StatusRequest request) throws RemoteException {
        URI identifier = this.retrieveSubscriptionId();
        try {
            Date leaseTime = this.getSubscriptionManager().getStatus(identifier);
            StatusResponse response = new StatusResponse();
            response.setExpires(leaseTime);
            return response;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    public RenewResponse renew(RenewRequest request) throws RemoteException {
        this.setReplyAction(EventingConstants.buildURI("http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse"));
        URI identifier = this.retrieveSubscriptionId();
        try {
            Date newLeaseTime = this.getSubscriptionManager().renew(identifier, request.getExpires());
            RenewResponse response = new RenewResponse();
            response.setExpires(newLeaseTime);
            return response;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    public void unsubscribe(UnsubscribeRequest request) throws RemoteException {
        this.setReplyAction(EventingConstants.buildURI("http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse"));
        URI identifier = this.retrieveSubscriptionId();
        try {
            this.getSubscriptionManager().unsubscribe(identifier);
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    private URI retrieveSubscriptionId() {
        URI subscriptionId = null;
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        AddressingProperties addrProps = (AddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
        if (null == addrProps) {
            throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "The message is not valid and cannot be processed:Cannot obtain addressing properties.", null, null);
        }
        ReferenceParameters refParams = addrProps.getReferenceParameters();
        if (refParams != null) {
            Iterator<Object> i$ = refParams.getElements().iterator();
            while (i$.hasNext()) {
                Element el;
                QName qname;
                Object obj = i$.next();
                if (!(obj instanceof Element) || !(qname = DOMUtils.getElementQName((Element)(el = (Element)obj))).equals(IDQN)) continue;
                try {
                    subscriptionId = new URI(DOMUtils.getTextContent((Node)el));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "The message is not valid and cannot be processed:Invalid subscription id.", null, null);
                }
            }
        }
        if (null == subscriptionId) {
            throw new SOAPFaultException(this.buildFaultQName("InvalidMessage"), "The message is not valid and cannot be processed.Cannot obtain subscription id.", null, null);
        }
        return subscriptionId;
    }
}

