/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.AnnotationImpl;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.lang.javassist.ScopedClassPoolRepository;

public class AnnotationHelper {
    private static final ScopedClassPoolRepository repository = ScopedClassPoolRepository.getInstance();

    public static boolean isAnnotationPresent(Class clazz, Class annotationClass) {
        return AnnotationHelper.getAnnotation(clazz, annotationClass) != null;
    }

    public static Object getAnnotation(Class clazz, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        Object[] arr$ = AnnotationHelper.getAnnotations(clazz);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object annotation = arr$[i$];
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return annotation;
        }
        return null;
    }

    public static Object[] getAnnotations(Class clazz) {
        try {
            return AnnotationHelper.getCtClass(clazz).getAnnotations();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("FIXME: should ignore annotations for missing classes");
        }
    }

    static CtClass getCtClass(Class clazz) {
        try {
            ClassPool pool = repository.findClassPool(clazz.getClassLoader());
            return pool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(new JBossStringBuilder().append("Unable to load CtClass for ").append(clazz).toString(), e);
        }
    }

    public static boolean isAnnotationPresent(Method method, Class annotationClass) {
        return AnnotationHelper.getAnnotation(method, annotationClass) != null;
    }

    public static Object getAnnotation(Method method, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        Object[] arr$ = AnnotationHelper.getAnnotations(method);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object annotation = arr$[i$];
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return annotation;
        }
        return null;
    }

    public static Object[] getAnnotations(Method method) {
        try {
            return AnnotationHelper.getCtMethod(method).getAnnotations();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("FIXME: should ignore annotations for missing classes");
        }
    }

    public static Object[][] getParameterAnnotations(Method method) {
        try {
            return AnnotationHelper.getCtMethod(method).getParameterAnnotations();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("FIXME: should ignore annotations for missing classes");
        }
    }

    static CtMethod getCtMethod(Method method) {
        CtClass clazz = AnnotationHelper.getCtClass(method.getDeclaringClass());
        Class<?>[] parameters = method.getParameterTypes();
        CtClass[] params = new CtClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = AnnotationHelper.getCtClass(parameters[i]);
        }
        CtClass returnType = AnnotationHelper.getCtClass(method.getReturnType());
        String descriptor = Descriptor.ofMethod((CtClass)returnType, (CtClass[])params);
        try {
            return clazz.getMethod(method.getName(), descriptor);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(new JBossStringBuilder().append("Unable to find method ").append(method).append(" descriptor=").append(descriptor).toString(), e);
        }
    }

    public static boolean isAnnotationPresent(Constructor constructor, Class annotationClass) {
        return AnnotationHelper.getAnnotation(constructor, annotationClass) != null;
    }

    public static Object getAnnotation(Constructor constructor, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        Object[] arr$ = AnnotationHelper.getAnnotations(constructor);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object annotation = arr$[i$];
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return annotation;
        }
        return null;
    }

    public static Object[] getAnnotations(Constructor constructor) {
        try {
            return AnnotationHelper.getCtConstructor(constructor).getAnnotations();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("FIXME: should ignore annotations for missing classes");
        }
    }

    public static Object[][] getParameterAnnotations(Constructor constructor) {
        try {
            return AnnotationHelper.getCtConstructor(constructor).getParameterAnnotations();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("FIXME: should ignore annotations for missing classes");
        }
    }

    static CtConstructor getCtConstructor(Constructor constructor) {
        CtClass clazz = AnnotationHelper.getCtClass(constructor.getDeclaringClass());
        Class<?>[] parameters = constructor.getParameterTypes();
        CtClass[] params = new CtClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = AnnotationHelper.getCtClass(parameters[i]);
        }
        String descriptor = Descriptor.ofConstructor((CtClass[])params);
        try {
            return clazz.getConstructor(descriptor);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(new JBossStringBuilder().append("Unable to find constructor descriptor=").append(descriptor).toString(), e);
        }
    }

    public static boolean isAnnotationPresent(Field field, Class annotationClass) {
        return AnnotationHelper.getAnnotation(field, annotationClass) != null;
    }

    public static Object getAnnotation(Field field, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        Object[] arr$ = AnnotationHelper.getAnnotations(field);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object annotation = arr$[i$];
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return annotation;
        }
        return null;
    }

    public static Object[] getAnnotations(Field field) {
        try {
            return AnnotationHelper.getCtField(field).getAnnotations();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("FIXME: should ignore annotations for missing classes");
        }
    }

    static CtField getCtField(Field field) {
        CtClass clazz = AnnotationHelper.getCtClass(field.getDeclaringClass());
        try {
            return clazz.getField(field.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(new JBossStringBuilder().append("Unable to find field ").append(field).toString(), e);
        }
    }

    private AnnotationHelper() {
    }
}

