/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jgroups.util.Util;

public class StateTransferIntegrator_123
implements StateTransferIntegrator {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private byte[] transient_state;
    private byte[] persistent_state;
    private TreeCache cache;

    StateTransferIntegrator_123(byte[] state, Fqn targetFqn, TreeCache cache) {
        if (targetFqn.size() > 0) {
            throw new IllegalArgumentException("Invalid FQN " + targetFqn + " -- StateTransferVersion 123 only supports " + "transferring  FQN '/'");
        }
        this.cache = cache;
        byte[][] states = null;
        try {
            this.log.info((Object)("received the state (size=" + state.length + " bytes)"));
            states = (byte[][])Util.objectFromByteBuffer((byte[])state);
            this.transient_state = states[0];
            this.persistent_state = states[1];
            if (this.transient_state != null) {
                this.log.info((Object)("transient state: " + this.transient_state.length + " bytes"));
            }
            if (this.persistent_state != null) {
                this.log.info((Object)("persistent state: " + this.persistent_state.length + " bytes"));
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"failed unserializing state", t);
        }
    }

    public void integrateTransientState(DataNode target, ClassLoader cl) throws Exception {
        block4: {
            target.clear();
            target.removeAllChildren();
            if (this.transient_state == null) break block4;
            try {
                this.log.info((Object)"setting transient state");
                Node new_root = (Node)Util.objectFromByteBuffer((byte[])this.transient_state);
                Map data = new_root.getData();
                target.put(data, true);
                Map children = new_root.getChildren();
                if (children != null) {
                    Iterator iter = children.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        target.addChild(entry.getKey(), (TreeNode)entry.getValue());
                    }
                }
                target.setRecursiveTreeCacheInstance(this.cache);
                this.log.info((Object)"setting the transient state was successful");
            }
            catch (Throwable t) {
                this.log.error((Object)"failed setting transient state", t);
            }
        }
    }

    public void integratePersistentState() throws Exception {
        block4: {
            if (this.persistent_state == null) break block4;
            CacheLoader cache_loader = this.cache.getCacheLoader();
            if (cache_loader == null) {
                this.log.error((Object)"cache loader is null, cannot set persistent state");
            } else {
                try {
                    this.log.info((Object)"setting the persistent state");
                    cache_loader.storeEntireState(this.persistent_state);
                    this.log.info((Object)"setting the persistent state was successful");
                }
                catch (Throwable t) {
                    this.log.error((Object)"failed setting persistent state", t);
                }
            }
        }
    }
}

