/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.DelegatingCacheLoader;
import org.jboss.cache.lock.TimeoutException;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;

public class RpcDelegatingCacheLoader
extends DelegatingCacheLoader {
    private int timeout;
    private TreeCache cache;
    private Address localAddress;
    public static Method METHOD_GET_STATE;
    public static Method METHOD_SET_STATE;
    public static Method METHOD_GET_CHILDREN_NAMES;
    public static Method METHOD_GET_WITH_2_PARAMS;
    public static Method METHOD_GET_WITH_1_PARAM;
    public static Method METHOD_EXISTS;
    public static Method METHOD_PUT_WITH_3_PARAMS;
    public static Method METHOD_PUT_WITH_2_PARAMS;
    public static Method METHOD_REMOVE_WITH_2_PARAMS;
    public static Method METHOD_REMOVE_WITH_1_PARAM;
    public static Method METHOD_REMOVE_DATA;
    static /* synthetic */ Class class$org$jboss$cache$TreeCache;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$org$jboss$cache$Fqn;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public RpcDelegatingCacheLoader() {
    }

    public RpcDelegatingCacheLoader(TreeCache cache, int timeout) {
        this.cache = cache;
        this.timeout = timeout;
    }

    public void setConfig(Properties props) {
        if (props == null) {
            return;
        }
        String t = props.getProperty("timeout");
        this.timeout = t == null || t.length() == 0 ? 5000 : Integer.parseInt(t);
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    protected Set delegateGetChildrenNames(Fqn name) throws Exception {
        return (Set)this.doMethodCall(METHOD_GET_CHILDREN_NAMES, new Object[]{name});
    }

    protected Object delegateGet(Fqn name, Object key) throws Exception {
        return this.doMethodCall(METHOD_GET_WITH_2_PARAMS, new Object[]{name, key});
    }

    protected Map delegateGet(Fqn name) throws Exception {
        DataNode n = (DataNode)this.doMethodCall(METHOD_GET_WITH_1_PARAM, new Object[]{name});
        if (n == null) {
            return null;
        }
        Map m = n.getData();
        if (m != null && m.size() > 0) {
            return m;
        }
        return null;
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        Boolean exists = (Boolean)this.doMethodCall(METHOD_EXISTS, new Object[]{name});
        return exists != null ? exists : false;
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        return this.doMethodCall(METHOD_PUT_WITH_3_PARAMS, new Object[]{name, key, value});
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        this.doMethodCall(METHOD_PUT_WITH_2_PARAMS, new Object[]{name, attributes});
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        return this.doMethodCall(METHOD_REMOVE_WITH_2_PARAMS, new Object[]{name, key});
    }

    protected void delegateRemove(Fqn name) throws Exception {
        this.doMethodCall(METHOD_REMOVE_WITH_1_PARAM, new Object[]{name});
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        this.doMethodCall(METHOD_REMOVE_DATA, new Object[]{name});
    }

    public byte[] delegateLoadEntireState() throws Exception {
        return (byte[])this.doMethodCall(METHOD_GET_STATE, new Object[0]);
    }

    public void delegateStoreEntireState(byte[] state) throws Exception {
        this.doMethodCall(METHOD_SET_STATE, new Object[]{state});
    }

    private Object doMethodCall(Method method, Object[] args) throws Exception {
        if (this.cache.isCoordinator()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Cannot delegate to the remote coordinator because the cache is itself the coordinator.");
            }
            return null;
        }
        if (this.localAddress == null) {
            this.localAddress = (Address)this.cache.getLocalAddress();
        }
        if (this.localAddress == null) {
            throw new Exception("Cannot delegate to the remote coordinator because the cache has no local address.");
        }
        Address coordinator = this.cache.getCoordinator();
        if (coordinator == null) {
            throw new Exception("Cannot delegate to the remote coordinator because the cache has no coordinator.");
        }
        Vector<Address> members = new Vector<Address>();
        members.add(coordinator);
        MethodCall methodCall = new MethodCall(method, args);
        boolean synchronous = true;
        boolean excludeSelf = true;
        List responses = this.cache.callRemoteMethods(members, methodCall, synchronous, excludeSelf, this.timeout);
        if (responses == null) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() was discarded!");
        }
        Object response = responses.get(0);
        if (response instanceof TimeoutException) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() timed out: " + response);
        }
        if (response instanceof Throwable) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() failed!", (Throwable)response);
        }
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            METHOD_GET_STATE = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("getStateBytes", new Class[0]);
            METHOD_SET_STATE = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("setStateBytes", array$B == null ? (array$B = RpcDelegatingCacheLoader.class$("[B")) : array$B);
            METHOD_GET_CHILDREN_NAMES = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("getChildrenNames", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            METHOD_GET_WITH_2_PARAMS = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("get", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = RpcDelegatingCacheLoader.class$("java.lang.Object")) : class$java$lang$Object);
            METHOD_GET_WITH_1_PARAM = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("get", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            METHOD_EXISTS = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("exists", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            METHOD_PUT_WITH_3_PARAMS = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("put", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = RpcDelegatingCacheLoader.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = RpcDelegatingCacheLoader.class$("java.lang.Object")) : class$java$lang$Object);
            METHOD_PUT_WITH_2_PARAMS = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("put", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$util$Map == null ? (class$java$util$Map = RpcDelegatingCacheLoader.class$("java.util.Map")) : class$java$util$Map);
            METHOD_REMOVE_WITH_2_PARAMS = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("remove", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn, class$java$lang$Object == null ? (class$java$lang$Object = RpcDelegatingCacheLoader.class$("java.lang.Object")) : class$java$lang$Object);
            METHOD_REMOVE_WITH_1_PARAM = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("remove", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
            METHOD_REMOVE_DATA = (class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = RpcDelegatingCacheLoader.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache).getDeclaredMethod("removeData", class$org$jboss$cache$Fqn == null ? (class$org$jboss$cache$Fqn = RpcDelegatingCacheLoader.class$("org.jboss.cache.Fqn")) : class$org$jboss$cache$Fqn);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

