/*
 * Decompiled with CFR 0.152.
 */
package components.renderkit;

import components.components.PaneSelectedEvent;
import components.renderkit.BaseRenderer;
import components.renderkit.Util;
import java.io.IOException;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;

public class TabLabelRenderer
extends BaseRenderer {
    protected String padLabel(String label) {
        if (label.length() == 3) {
            label = "&nbsp;&nbsp;" + label + "&nbsp;&nbsp;";
        } else if (label.length() == 2) {
            label = "&nbsp;&nbsp;&nbsp;" + label + "&nbsp;&nbsp;&nbsp;";
        }
        return label;
    }

    protected String getImageSrc(FacesContext context, UIComponent component) {
        String result = (String)component.getAttributes().get("image");
        if (result != null && !result.startsWith("/")) {
            result = "/" + result;
            component.getAttributes().put("image", result);
        }
        if (result == null) {
            try {
                result = this.getKeyAndLookupInBundle(context, component, "imageKey");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (result == null) {
            return result;
        }
        String contextPath = context.getExternalContext().getRequestContextPath();
        StringBuffer sb = new StringBuffer();
        if (result.startsWith("/")) {
            sb.append(contextPath);
        }
        sb.append(result);
        return context.getExternalContext().encodeResourceURL(sb.toString());
    }

    protected String getLabel(FacesContext context, UIComponent component) throws IOException {
        String result = null;
        try {
            result = this.getKeyAndLookupInBundle(context, component, "key");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (null == result) {
            result = (String)component.getAttributes().get("label");
        }
        return result;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException("Null Faces context or component parameter");
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameterMap.get(clientId);
        if (value == null && requestParameterMap.get(clientId + ".x") == null && requestParameterMap.get(clientId + ".y") == null) {
            return;
        }
        UIComponent tabComponent = this.findParentForRendererType(component, "Tab");
        tabComponent.queueEvent((FacesEvent)new PaneSelectedEvent(component, tabComponent.getId()));
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException("Null Faces context or component parameter");
        }
        if (!component.isRendered()) {
            return;
        }
        String paneTabLabelClass = null;
        ResponseWriter writer = context.getResponseWriter();
        String imageSrc = this.getImageSrc(context, component);
        String label = this.getLabel(context, component);
        String type = "submit";
        if (imageSrc != null || label != null) {
            writer.write("<input type=");
            if (null != imageSrc) {
                writer.write("\"image\" src=\"");
                writer.write(imageSrc);
                writer.write("\"");
                writer.write(" name=\"");
                writer.write(component.getClientId(context));
                writer.write("\"");
            } else {
                writer.write("\"");
                writer.write(type.toLowerCase());
                writer.write("\"");
                writer.write(" name=\"");
                writer.write(component.getClientId(context));
                writer.write("\"");
                writer.write(" value=\"");
                writer.write(this.padLabel(label));
                writer.write("\"");
            }
        }
        writer.write(Util.renderPassthruAttributes(context, component));
        writer.write(Util.renderBooleanPassthruAttributes(context, component));
        paneTabLabelClass = (String)component.getAttributes().get("paneTabLabelClass");
        if (null != paneTabLabelClass) {
            writer.write(" class=\"" + paneTabLabelClass + "\" ");
        }
        writer.write(">");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException("Null Faces context or component parameter.");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException("Null Faces context or component parameter.");
        }
    }

    private UIComponent findParentForRendererType(UIComponent component, String rendererType) {
        Object facetParent = null;
        UIComponent currentComponent = component;
        while (null != (currentComponent = currentComponent.getParent())) {
            if (currentComponent.getRendererType().equals(rendererType)) break;
        }
        return currentComponent;
    }
}

