/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class LongType
extends IntType {
    public LongType(int num) {
        super(num);
    }

    public Object clone() {
        return new LongType(LongType.new_num());
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public String typeName() {
        return "int";
    }

    public String getJavaTypeName() {
        return "int";
    }

    public String getIDLTypeName() {
        if (this.unsigned) {
            return "ulong";
        }
        return "long";
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        return this.unsigned ? 5 : 3;
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.IntHolder";
    }

    public String printReadExpression(String ps) {
        if (this.unsigned) {
            return ps + ".read_ulong()";
        }
        return ps + ".read_long()";
    }

    public String printWriteStatement(String var_name, String ps) {
        if (this.unsigned) {
            return ps + ".write_ulong(" + var_name + ");";
        }
        return ps + ".write_long(" + var_name + ");";
    }

    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ulong";
        }
        return "insert_long";
    }

    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ulong";
        }
        return "extract_long";
    }

    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }
}

