/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeSpec;

class BooleanType
extends BaseType
implements SwitchTypeSpec {
    public BooleanType(int num) {
        super(num);
    }

    public String typeName() {
        return "boolean";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        return 8;
    }

    public String toString() {
        return this.typeName();
    }

    public void parse() {
    }

    public String holderName() {
        return "org.omg.CORBA.BooleanHolder";
    }

    public String printReadExpression(String strname) {
        return strname + ".read_boolean()";
    }

    public String printWriteStatement(String var_name, String strname) {
        return strname + ".write_boolean(" + var_name + ");";
    }

    public String printInsertExpression() {
        return "insert_boolean";
    }

    public String printExtractExpression() {
        return "extract_boolean";
    }

    public boolean isSwitchable() {
        return true;
    }

    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }
}

