/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.BasicMessageQueueAdapter;
import org.jacorb.notification.queue.BoundedDeadlineEventQueue;
import org.jacorb.notification.queue.BoundedFifoEventQueue;
import org.jacorb.notification.queue.BoundedPriorityEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.MessageQueueAdapter;
import org.jacorb.notification.util.QoSPropertySet;

public class EventQueueFactory
implements Configurable {
    private static final short UNKNOWN_POLICY = Short.MIN_VALUE;
    private static final Map mapOrderPolicyNameToValue;
    private static final Map mapDiscardPolicyNameToValue;
    private String orderPolicy_;
    private String discardPolicy_;

    public EventQueueFactory(Configuration configuration) throws ConfigurationException {
        this.configure(configuration);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            this.setOrderPolicy(configuration.getAttribute("jacorb.notification.order_policy", "PriorityOrder"));
            this.setDiscardPolicy(configuration.getAttribute("jacorb.notification.discard_policy", "PriorityOrder"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConfigurationException("Invalid Policy", (Throwable)illegalArgumentException);
        }
    }

    private void setDiscardPolicy(String string) {
        String string2 = string.toLowerCase().trim();
        if (!mapDiscardPolicyNameToValue.containsKey(string2)) {
            throw new IllegalArgumentException("Invalid DiscardPolicy: " + string);
        }
        this.discardPolicy_ = string2;
    }

    private void setOrderPolicy(String string) {
        String string2 = string.toLowerCase().trim();
        if (!mapOrderPolicyNameToValue.containsKey(string2)) {
            throw new IllegalArgumentException("Invalid OrderPolicy: " + string);
        }
        this.orderPolicy_ = string2;
    }

    public MessageQueueAdapter newMessageQueue(QoSPropertySet qoSPropertySet) {
        AbstractBoundedEventQueue abstractBoundedEventQueue;
        EventQueueOverflowStrategy eventQueueOverflowStrategy;
        int n;
        short s = EventQueueFactory.orderPolicyNameToValue(this.orderPolicy_);
        short s2 = EventQueueFactory.discardPolicyNameToValue(this.discardPolicy_);
        try {
            n = qoSPropertySet.get("MaxEventsPerConsumer").extract_long();
        }
        catch (Exception exception) {
            n = 100;
        }
        if (qoSPropertySet.containsKey("OrderPolicy")) {
            s = qoSPropertySet.get("OrderPolicy").extract_short();
        }
        if (qoSPropertySet.containsKey("DiscardPolicy")) {
            s2 = qoSPropertySet.get("DiscardPolicy").extract_short();
        }
        switch (s2) {
            case 0: 
            case 1: {
                eventQueueOverflowStrategy = EventQueueOverflowStrategy.FIFO;
                break;
            }
            case 4: {
                eventQueueOverflowStrategy = EventQueueOverflowStrategy.LIFO;
                break;
            }
            case 2: {
                eventQueueOverflowStrategy = EventQueueOverflowStrategy.LEAST_PRIORITY;
                break;
            }
            case 3: {
                eventQueueOverflowStrategy = EventQueueOverflowStrategy.EARLIEST_TIMEOUT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Discardpolicy: " + this.discardPolicy_ + "DiscardPolicyValue: " + s2 + " unknown");
            }
        }
        switch (s) {
            case 0: 
            case 1: {
                abstractBoundedEventQueue = new BoundedFifoEventQueue(n, eventQueueOverflowStrategy);
                break;
            }
            case 2: {
                abstractBoundedEventQueue = new BoundedPriorityEventQueue(n, eventQueueOverflowStrategy);
                break;
            }
            case 3: {
                abstractBoundedEventQueue = new BoundedDeadlineEventQueue(n, eventQueueOverflowStrategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Orderpolicy: " + this.orderPolicy_ + " OrderPolicyValue: " + s + " unknown");
            }
        }
        return new BasicMessageQueueAdapter(abstractBoundedEventQueue);
    }

    private static short orderPolicyNameToValue(String string) {
        if (mapOrderPolicyNameToValue.containsKey(string.toLowerCase())) {
            return (Short)mapOrderPolicyNameToValue.get(string);
        }
        return Short.MIN_VALUE;
    }

    private static short discardPolicyNameToValue(String string) {
        if (mapDiscardPolicyNameToValue.containsKey(string.toLowerCase())) {
            return (Short)mapDiscardPolicyNameToValue.get(string);
        }
        return Short.MIN_VALUE;
    }

    static {
        HashMap<String, Short> hashMap = new HashMap<String, Short>();
        hashMap.put("anyorder", new Short(0));
        hashMap.put("fifoorder", new Short(1));
        hashMap.put("priorityorder", new Short(2));
        hashMap.put("deadlineorder", new Short(3));
        mapOrderPolicyNameToValue = Collections.unmodifiableMap(hashMap);
        HashMap<String, Short> hashMap2 = new HashMap<String, Short>();
        hashMap2.put("anyorder", new Short(0));
        hashMap2.put("fifoorder", new Short(1));
        hashMap2.put("lifoorder", new Short(4));
        hashMap2.put("priorityorder", new Short(2));
        hashMap2.put("deadlineorder", new Short(3));
        mapDiscardPolicyNameToValue = Collections.unmodifiableMap(hashMap2);
    }
}

