/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.filter.AbstractFilter;
import org.jacorb.notification.filter.IFilterFactoryDelegate;
import org.jacorb.notification.filter.MappingFilterImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.GCDisposable;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.CosNotifyFilter.FilterFactoryPOA;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class FilterFactoryImpl
extends FilterFactoryPOA
implements Disposable,
ManageableServant {
    private final ORB orb_;
    private final POA poa_;
    private final DisposableManager disposeHooks_ = new DisposableManager();
    private final List allFilters_ = new ArrayList();
    private final java.lang.Object allFiltersLock_ = new java.lang.Object();
    protected final Logger logger_;
    private FilterFactory thisFilter_;
    private final IFilterFactoryDelegate factoryDelegate_;
    private final boolean useGarbageCollector_;
    private final Configuration config_;

    public FilterFactoryImpl(ORB oRB, POA pOA, Configuration configuration, IFilterFactoryDelegate iFilterFactoryDelegate) {
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.factoryDelegate_ = iFilterFactoryDelegate;
        this.config_ = configuration;
        this.logger_ = LogUtil.getLogger(configuration, this.getClass().getName());
        this.useGarbageCollector_ = configuration.getAttributeAsBoolean("jacorb.notification.enable_gc", false);
        if (this.useGarbageCollector_) {
            this.logger_.info("Enable Garbage Collection for Filters");
            GCThread gCThread = new GCThread();
            this.addDisposeHook(gCThread);
            gCThread.start();
        }
    }

    public final void addDisposeHook(Disposable disposable) {
        this.disposeHooks_.addDisposable(disposable);
    }

    public final Filter create_filter(String string) throws InvalidGrammar {
        AbstractFilter abstractFilter = this.factoryDelegate_.create_filter_servant(string);
        this.registerFilter(abstractFilter);
        Filter filter = FilterHelper.narrow(abstractFilter.activate());
        return filter;
    }

    public MappingFilter create_mapping_filter(String string, Any any) throws InvalidGrammar {
        MappingFilterImpl mappingFilterImpl = this.factoryDelegate_.create_mapping_filter_servant(this.config_, string, any);
        this.registerFilter(mappingFilterImpl);
        MappingFilter mappingFilter = MappingFilterHelper.narrow(mappingFilterImpl.activate());
        return mappingFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerFilter(final GCDisposable gCDisposable) {
        if (this.useGarbageCollector_) {
            java.lang.Object object = this.allFiltersLock_;
            synchronized (object) {
                this.allFilters_.add(gCDisposable);
                gCDisposable.registerDisposable(new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        java.lang.Object object = FilterFactoryImpl.this.allFiltersLock_;
                        synchronized (object) {
                            FilterFactoryImpl.this.allFilters_.remove(gCDisposable);
                        }
                    }
                });
            }
        }
    }

    public final void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.getServant()));
        }
        catch (Exception exception) {
            this.logger_.fatalError("cannot deactivate object", (Throwable)exception);
            throw new RuntimeException();
        }
    }

    protected Servant getServant() {
        return this;
    }

    public synchronized Object activate() {
        if (this.thisFilter_ == null) {
            this.thisFilter_ = FilterFactoryHelper.narrow(this.getServant()._this_object(this.orb_));
        }
        return this.thisFilter_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        try {
            this.deactivate();
        }
        finally {
            this.disposeHooks_.dispose();
        }
    }

    public final POA _default_POA() {
        return this.poa_;
    }

    protected final ORB getORB() {
        return this.orb_;
    }

    private class GCThread
    extends Thread
    implements Disposable {
        private final AtomicBoolean active = new AtomicBoolean(true);

        public GCThread() {
            this.setName("NotificationService Filter GC");
            this.setPriority(2);
        }

        public void run() {
            while (this.active.get()) {
                try {
                    Thread.sleep(1000L);
                    this.runLoop();
                }
                catch (InterruptedException interruptedException) {}
            }
            FilterFactoryImpl.this.logger_.info("GCThread exits");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLoop() throws InterruptedException {
            java.lang.Object object = FilterFactoryImpl.this.allFiltersLock_;
            synchronized (object) {
                Iterator iterator = new ArrayList(FilterFactoryImpl.this.allFilters_).iterator();
                while (iterator.hasNext()) {
                    GCDisposable gCDisposable = (GCDisposable)iterator.next();
                    try {
                        gCDisposable.attemptDispose();
                    }
                    catch (Exception exception) {
                        iterator.remove();
                    }
                    this.verifyIsActive();
                }
            }
        }

        private void verifyIsActive() throws InterruptedException {
            if (!this.active.get()) {
                throw new InterruptedException();
            }
        }

        public void dispose() {
            FilterFactoryImpl.this.logger_.info("Shutdown GCThread");
            this.active.set(false);
        }
    }
}

