/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxb;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jboss.util.NotImplementedException;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxb.SchemaBindingBuilder;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBUnmarshallerImpl
implements Unmarshaller {
    private HashMap<String, Object> properties = new HashMap();

    public Object unmarshal(InputStream is) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = this.getSchemaBinding();
        try {
            return unm.unmarshal(is, schemaBinding);
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        throw new NotImplementedException();
    }

    public Object unmarshal(File file) throws JAXBException {
        this.assertRequiredProperties();
        try {
            return this.unmarshal(file.toURL());
        }
        catch (MalformedURLException e) {
            throw new WSException("Malformed URL for file " + file.toString() + ": " + e.getMessage());
        }
    }

    public Object unmarshal(InputSource source) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = this.getSchemaBinding();
        try {
            if (source.getByteStream() != null) {
                return unm.unmarshal(source.getByteStream(), schemaBinding);
            }
            if (source.getCharacterStream() != null) {
                return unm.unmarshal(source.getCharacterStream(), schemaBinding);
            }
            if (source.getSystemId() != null) {
                return unm.unmarshal(source.getSystemId(), schemaBinding);
            }
            throw new WSException("InputSource instance does not contain any source information.");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public Object unmarshal(Node node) {
        throw new NotImplementedException();
    }

    public Object unmarshal(Source source) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = this.getSchemaBinding();
        try {
            return unm.unmarshal(source.getSystemId(), schemaBinding);
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public Object unmarshal(URL url) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = this.getSchemaBinding();
        try {
            return unm.unmarshal(url.toString(), schemaBinding);
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public ValidationEventHandler getEventHandler() {
        throw new NotImplementedException();
    }

    public void setEventHandler(ValidationEventHandler handler) {
        throw new NotImplementedException();
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        this.properties.put(name, value);
    }

    public boolean isValidating() {
        return false;
    }

    public void setValidating(boolean validating) {
        if (validating) {
            throw new NotImplementedException();
        }
    }

    private SchemaBinding getSchemaBinding() {
        SchemaBinding schemaBinding = null;
        SchemaBindingBuilder bindingBuilder = new SchemaBindingBuilder();
        QName xmlName = (QName)this.getProperty("org.jboss.jaxb.root.qname");
        QName xmlType = (QName)this.getProperty("org.jboss.jaxb.type.qname");
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            OperationMetaData opMetaData = msgContext.getOperationMetaData();
            EndpointMetaData epMetaData = opMetaData.getEndpointMetaData();
            ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
            schemaBinding = serviceMetaData.getSchemaBinding();
        }
        if (schemaBinding == null) {
            JBossXSModel xsModel = (JBossXSModel)this.getProperty("org.jboss.jaxb.xsd.xsmodel");
            JavaWsdlMapping wsdlMapping = (JavaWsdlMapping)this.getProperty("org.jboss.jaxb.java.mapping");
            schemaBinding = bindingBuilder.buildSchemaBinding(xsModel, wsdlMapping);
        }
        bindingBuilder.bindParameterToElement(schemaBinding, xmlName, xmlType);
        return schemaBinding;
    }

    private void assertRequiredProperties() {
        if (this.getProperty("org.jboss.jaxb.xsd.xsmodel") == null) {
            throw new WSException("Cannot find required property: org.jboss.jaxb.xsd.xsmodel");
        }
        if (this.getProperty("org.jboss.jaxb.java.mapping") == null) {
            throw new WSException("Cannot find required property: org.jboss.jaxb.java.mapping");
        }
    }
}

