/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:ClientSideJSETestCase.java,v 1.0, 2005-06-24 18:58:05Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

/**
 * Test access to the webservice via an servlet client
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class ClientSideJSETestCase extends JBossTestCase
{

   public ClientSideJSETestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ClientSideJSETestCase.class, "ws4ee-samples-server-jse.war, ws4ee-samples-server-ejb.jar, ws4ee-samples-client-web.war");
   }

   /** Test access to the webservice via an EJB client */
   public void testServletClientAccessEJB() throws Exception
   {
      URL url = new URL("http://localhost:8080/ws4ee-samples-client-web?organization=mafia&endpoint=EJB&method=info");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      String info = br.readLine();
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
   }

   /** Test access to the webservice via an EJB client */
   public void testServletClientAccessJSESimple() throws Exception
   {
      URL url = new URL("http://localhost:8080/ws4ee-samples-client-web?organization=mafia&endpoint=JSE&method=info");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      String info = br.readLine();
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
   }
}
