/* JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.jaf;

import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;

import org.jboss.logging.Logger;

/**
 * A pojo service which can be used to populate the JAF MailcapCommandMap with
 * mailcap content-type to DataContentHandler class. The default mailcaps are
 * text/xml, application/xml mapping to org.jboss.webservice.jaf.XMLDataContentHandler
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 * @see javax.activation.DataContentHandler
 * @see javax.activation.MailcapCommandMap
 * @see org.jboss.webservice.jaf.XMLDataContentHandler
 */
public class JAFConfigService
{
   private static Logger log = Logger.getLogger(JAFConfigService.class);
   /**
    * The default mapping is for xml -> XMLDataContentHandler
    */
   private String[] mailcaps = {
      "text/xml;;x-java-content-handler=org.jboss.webservice.jaf.XMLDataContentHandler",
      "application/xml;;x-java-content-handler=org.jboss.webservice.jaf.XMLDataContentHandler"
   };

   public String[] getMailcaps()
   {
      return mailcaps;
   }

   public void setMailcaps(String[] mailcaps)
   {
      this.mailcaps = mailcaps;
   }

   /**
    * Register the mailcaps with the default MailcapCommandMap
    *
    * @throws Exception
    * @see MailcapCommandMap
    */
   public void start() throws Exception
   {
      CommandMap commandMap = CommandMap.getDefaultCommandMap();
      if (commandMap instanceof MailcapCommandMap)
      {
         MailcapCommandMap mailMap = (MailcapCommandMap)commandMap;
         for (int n = 0; n < mailcaps.length; n++)
         {
            String mailcap = mailcaps[n];
            mailMap.addMailcap(mailcap);
            log.debug("Added mailcap: " + mailcap);
         }
      }
      else
      {
         throw new Exception("Cannot handle non-MailcapCommandMap, map="
                 + commandMap);
      }
   }

   /**
    * Do nothing since MailcapCommandMap does not support removal of mailcaps
    *
    * @throws Exception
    */
   public void stop() throws Exception
   {
   }

}
