/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:ServerLoginHandler.java,v 1.0, 2005-06-24 19:15:55Z, Robert Worsnop$
package org.jboss.webservice.handler;

// $Id:ServerLoginHandler.java,v 1.0, 2005-06-24 19:15:55Z, Robert Worsnop$

import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.encoding.Base64;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.webservice.Constants;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import java.util.Iterator;

/**
 * An Axis style handler that gets username/password from SOAP header elements.
 *
 * &lt;soapenv:Header>
 *    &lt;jbws:username actor="http://webservice.jboss.com/ws4ee/login" xmlns:jbws="http://webservice.jboss.com/ws4ee">kermit&lt;/jbws:username>
 *    &lt;jbws:password actor="http://webservice.jboss.com/ws4ee/login" xmlns:jbws="http://webservice.jboss.com/ws4ee">thefrog&lt;/jbws:password>
 * &lt;/soapenv:Header>
 *
 *
 * @author Thomas.Diesler@jboss.org
 * @since 27-April-2004
 */
public class ServerLoginHandler extends BasicHandler
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 8239981936517243635L;

   // provide logging
   private static final Logger log = Logger.getLogger(ServerLoginHandler.class);

   /** Extract the username/password and set principal/credential in the SecurityAssociation.
    */
   public void invoke(MessageContext msgContext) throws AxisFault
   {
      try
      {
         SOAPMessage soapMessage = msgContext.getMessage();
         SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
         Iterator it = soapHeader.extractHeaderElements(Constants.NAMESPACE + "/login");
         while (it.hasNext())
         {
            SOAPHeaderElement element = (SOAPHeaderElement)it.next();
            String localName = element.getElementName().getLocalName();
            String value = element.getValue();
            if (localName.equals("username"))
            {
               SecurityAssociation.setPrincipal(new SimplePrincipal(value));
            }
            if (localName.equals("password"))
            {
               String password = new String(Base64.decode(value));
               SecurityAssociation.setCredential(password);
            }
         }
      }
      catch (SOAPException e)
      {
         log.error("Server login failed: " + e.toString());
         throw new AxisFault("Server login failed", e);
      }
   }
}
