/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:ServiceClientDeployer.java,v 1.0, 2005-06-24 19:15:58Z, Robert Worsnop$
package org.jboss.webservice;

// $Id:ServiceClientDeployer.java,v 1.0, 2005-06-24 19:15:58Z, Robert Worsnop$

import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.webservice.client.ServiceReferenceable;
import org.jboss.webservice.metadata.ServiceRefMetaData;

import javax.naming.Context;
import java.util.Iterator;

/**
 * Binds a JAXRPC Service object in the client's ENC for every service-ref element in the
 * deployment descriptor.
 *
 * @author Thomas.Diesler@jboss.org
 * @jmx.mbean name="jboss.ws4ee:service=ServiceClientDeployer"
 * description="Webservice client deployer"
 * extends="org.jboss.system.ServiceMBean"
 * @since 27-April-2004
 */
public class ServiceClientDeployer extends ServiceMBeanSupport
        implements ServiceClientDeployerMBean, WebServiceClientDeployment
{
   // provide logging
   private static final Logger log = Logger.getLogger(ServiceClientDeployer.class);

   /**
    * This binds a jaxrpc Service into the callers ENC for every service-ref element
    *
    * @param envCtx      ENC to bind the javax.rpc.xml.Service object to
    * @param serviceRefs An iterator of the service-ref elements in the client deployment descriptor
    * @param di          The client's deployment info
    * @throws org.jboss.deployment.DeploymentException
    *          if it goes wrong
    * @jmx.managed-operation
    */
   public void setupServiceRefEnvironment(Context envCtx, Iterator serviceRefs, DeploymentInfo di)
           throws DeploymentException
   {
      try
      {
         while (serviceRefs.hasNext())
         {
            ServiceRefMetaData serviceRef = (ServiceRefMetaData)serviceRefs.next();
            String serviceRefName = serviceRef.getServiceRefName();

            ServiceReferenceable ref = new ServiceReferenceable(serviceRef, di);
            Util.bind(envCtx, serviceRefName, ref);

            log.debug("Webservice binding: java:comp/env/" + serviceRefName);
         }
      }
      catch (Exception e)
      {
         throw new DeploymentException("Cannot bind webservice to client environment", e);
      }
   }
}
