/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.loadbalancer.monitor;

import org.apache.commons.httpclient.HttpMethod;

/**
 * A monitor service that does no further content checking.
 * @jmx:mbean name="jboss.web.loadbalancer: service=SimpleMonitor"
 *            extends="org.jboss.web.loadbalancer.monitor.AbstractMonitorMBean"
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision:1$
 */
public class SimpleMonitorService extends AbstractMonitor implements SimpleMonitorServiceMBean
{
  protected boolean checkHostStatus(HttpMethod method)
  {
    // do no further checking
    return true;
  }
}