/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
 
package org.jboss.monitor.alarm;

import javax.management.ObjectName;
import javax.management.Notification;

/**
 * MBeanImplAccess
 *
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 *
 * @version $Revision:1$
**/
public interface MBeanImplAccess
{
   /**
    * Gets the MBean ObjectName
   **/
   public ObjectName getMBeanName();
   
   /**
    * Gets the next notification sequence number
   **/
   public long getSequenceNumber();
   
   /**
    * Broadcasts a notification to listeners
   **/
   public void emitNotification(Notification notification);
   
}
