/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
 
package org.jboss.monitor.alarm;

import javax.management.ObjectName;

/**
 * AlarmKey
 *
 * An alarm is equivalent if serverId/source/type match
 *
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 *
 * @version $Revision:1$
**/
class AlarmKey
{
   // Constants -----------------------------------------------------
   
   public static final String BAD_SOURCE = "NonObjectNameSource";

   // Private Data --------------------------------------------------
   
   private String alarmId;

   // Static Helper -------------------------------------------------  
   
   public static AlarmKey createKey(String serverId, Object source, String type)
   {
      if (source instanceof ObjectName)
         return new AlarmKey(serverId, source.toString(), type);
      else if (source instanceof String)
         return new AlarmKey(serverId, (String)source, type);
      else
         return new AlarmKey(serverId, BAD_SOURCE, type);      
   }
   
   // Constructor ---------------------------------------------------
   
   public AlarmKey(String serverId, String source, String type)
   {
      StringBuffer sbuf = new StringBuffer(256);
      
      sbuf.append(serverId);
      sbuf.append('+').append(source);
      sbuf.append('+').append(type);
      
      alarmId = sbuf.toString();
   }
   
   // Object stuff --------------------------------------------------
   
   /**
    * Bases equality on alarmId equality
   **/
   public boolean equals(Object obj)
   {
      if (obj instanceof AlarmKey)
         return ((AlarmKey)obj).alarmId.equals(this.alarmId);
      else
         return false;
   }
   
   /**
    * Makes use of alarmId's hashCode
   **/
   public int hashCode()
   {
      return this.alarmId.hashCode();
   }
   
   /**
    * Pretty prints
   **/
   public String toString()
   {
      StringBuffer sbuf = new StringBuffer(256);
      
      sbuf.append("AlarmKey[").append(this.alarmId).append("]");
      
      return sbuf.toString();
   }
}
