/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import javax.management.Notification;
import javax.management.ObjectName;
import java.util.Map;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 *
 **/
public class StringThresholdNotification
        extends JBossMonitorNotification
{
   public static final String TRIGGERED_ATTRIBUTE_VALUE="TRIGGERED_ATTRIBUTE_VALUE";
   public static final String THRESHOLD = "THRESHOLD";

   private final String value;
   private final String threshold;
   private final boolean equality;

   public StringThresholdNotification(String monitorName, ObjectName monitorObjectName, ObjectName observedObject,
                                String attribute, String value, String threshold, boolean equality, long sequenceNumber)
   {
      super(monitorName, monitorObjectName, observedObject, attribute, sequenceNumber);
      this.value = value;
      this.threshold = threshold;
      this.equality = equality;
   }

   public String getValue()
   {
      return value;
   }

   public String getThreshold()
   {
      return threshold;
   }


   public boolean getEquality()
   {
      return equality;
   }

   /**
    * Return a substitution map that can be used by org.jboss.util.Strings.subst
    * to create a printable alert message.
    *
    * @return
    */
   public Map substitutionMap()
   {
      Map map = super.substitutionMap();
      map.put(TRIGGERED_ATTRIBUTE_VALUE, value);
      map.put(THRESHOLD, threshold);
      return map;
   }
}
