/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import org.jboss.system.ServiceMBeanSupport;
import org.jboss.logging.Logger;

import javax.management.ObjectName;
import javax.management.MBeanException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 *
 **/
public class StringThresholdMonitor extends JBossMonitor implements StringThresholdMonitorMBean
{
   protected String thresholdString;
   protected boolean equalityTriggersAlert;

   protected void testThreshold()
   {
      if (alertSent) return;
      String value = null;
      try
      {
         value = (String)getServer().getAttribute(observedObject, attribute);
         if (equalityTriggersAlert) // alert trigger when value == threshold
         {
            if (!thresholdString.equals(value))
            {
               return;
            }
         }
         else // alert triggered when value != threshold
         {
            if (thresholdString.equals(value))
            {
               return;
            }
         }
      }
      catch (Exception e)
      {
         throw new RuntimeException("Failed to compare threshold, mbean failure");
      }

      alertSent = true;
      triggerTime = System.currentTimeMillis();
      triggeredAttributeValue = value;

      StringThresholdNotification notification = new StringThresholdNotification(monitorName, getServiceName(), observedObject,
              attribute, value, thresholdString, equalityTriggersAlert,
              getNextNotificationSequenceNumber());
      this.sendNotification(notification);
   }

   public String getThreshold()
   {
      return thresholdString;
   }

   public void setThreshold(String val)
   {
      thresholdString = val;
   }

   public boolean getEqualityTriggersAlert()
   {
      return equalityTriggersAlert;
   }

   public void setEqualityTriggersAlert(boolean compareEqual)
   {
      this.equalityTriggersAlert = compareEqual;
   }
}
