/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import javax.management.Notification;
import javax.management.ObjectName;
import java.util.Map;
import java.util.HashMap;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 *
 **/
public class JBossMonitorNotification extends Notification
{
   public static final String NOTIFICATION_TYPE = "JBOSS_MONITOR_NOTIFICATION";
   public static final String OBSERVED_OBJECT = "OBSERVED_OBJECT";
   public static final String MONITOR_OBJECT_NAME = "MONITOR_OBJECT_NAME";
   public static final String MONITOR_NAME = "MONITOR_NAME";
   public static final String ATTRIBUTE = "ATTRIBUTE";


   protected final ObjectName observedObject;
   protected final ObjectName monitorObjectName;
   protected final String monitorName;
   protected final String attribute;

   public JBossMonitorNotification(String monitorName, ObjectName monitorObjectName, ObjectName observedObject,
                                String attribute, long sequenceNumber)
   {
      super(NOTIFICATION_TYPE, monitorObjectName, sequenceNumber);
      this.observedObject = observedObject;
      this.attribute = attribute;
      this.monitorName = monitorName;
      this.monitorObjectName = monitorObjectName;
   }

   public ObjectName getObservedObject()
   {
      return observedObject;
   }

   public ObjectName getMonitorObjectName()
   {
      return monitorObjectName;
   }

   public String getMonitorName()
   {
      return monitorName;
   }

   public String getAttribute()
   {
      return attribute;
   }

   /**
    * Return a substitution map that can be used by org.jboss.util.Strings.subst
    * to create a printable alert message.
    *
    * @return
    */
   public Map substitutionMap()
   {
      HashMap map = new HashMap();
      map.put(OBSERVED_OBJECT, observedObject.toString());
      map.put(MONITOR_OBJECT_NAME, monitorObjectName.toString());
      map.put(MONITOR_NAME, monitorName);
      map.put(ATTRIBUTE, attribute);
      return map;
   }
}
