/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.jaxr.juddi.axis;

/*import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;*/

import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;


/**
 * Axis Handler for jUDDI in JBoss
 *
 * @author <mailto:Anil.Saldhana@jboss.org>Anil Saldhana
 * @since Nov 20, 2004
 */
public class JBossJuddiAxisHandler extends BasicHandler
{
     /**
   * Init is called when the chain containing this
   * Handler object is instantiated.
   */
  public void init()
  {
    super.init();
  }

  /**
   * Cleanup is called when the chain containing this
   * Handler object is done processing the chain.
   */
  public void cleanup()
  {
    super.cleanup();
  }

  /**
   * Invoke is called to do the actual work of the
   * Handler object. If there is a fault during the
   * processing of this method it is invoke's job to
   * catch the exception and undo any partial work that
   * has been completed. Once we leave 'invoke' if a
   * fault is thrown, this classes 'onFault' method
   * will be called. Invoke should rethrow any
   * exceptions it catches, wrapped in an AxisFault.
   */
  public void invoke(MessageContext context)
  {
    Message response = new Message(new SOAPEnvelopeAxisImpl());
    /*Message request = context.getRequestMessage();

    // Determine if this message came from through
    // the Publish, Inquiry or Admin API and handle
    // it appropriately.

    Object servlet = context.getProperty("transport.http.servlet");*/

    new JBossJuddiAxisProcessor(response,context);

    context.setResponseMessage(response);
  }
}

