/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.jaxr.juddi;

import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;

/**
 * MBean interface.
 * @since Nov 8, 2004
 */
public interface JUDDIServiceMBean extends org.jboss.system.ServiceMBean {

   //default object name
   public static final ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss:service=juddi");

  boolean isDropOnStart() ;

   /**
    * Sets the dropOnStart.
    * @param dropOnStart The dropOnStart to set
    */
  void setDropOnStart(boolean dropOnStart) ;

  boolean isDropOnStop() ;

   /**
    * Sets the dropOnStop.
    * @param dropOnStop The dropOnStop to set
    */
  void setDropOnStop(boolean dropOnStop) ;

  boolean isCreateOnStart() ;

   /**
    * Sets the createOnStart.
    * @param createOnStart The createOnStart to set
    */
  void setCreateOnStart(boolean createOnStart) ;

  java.lang.String getDataSource() ;

   /**
    * Sets the Datasource Url.
    * @param ds The datasourceurl to set
    */
  void setDataSourceUrl(java.lang.String ds) ;

  java.lang.String getRegistryOperator() ;

   /**
    * Sets the RegistryOperator.
    * @param ro The datasourceurl to set
    */
  void setRegistryOperator(java.lang.String ro) ;

   /**
    * gets the JAXR ConnectionFactory.
    */
  java.lang.String getBindJaxr() ;

   /**
    * Sets the JAXR ConnectionFactory.
    * @param str The context to bind the Jaxr factory to set
    */
  void setBindJaxr(java.lang.String str) ;

   /**
    * gets the JAXR ConnectionFactory.
    */
  boolean getShouldBindJaxr() ;

   /**
    * Sets the JAXR ConnectionFactory.
    * @param str Should a Jaxr Connection Factory bound
    */
  void setShouldBindJaxr(boolean str) ;

   /**
    * gets the JAXR ConnectionFactory.
    */
  boolean getDropDB() ;

   /**
    * Sets the JAXR ConnectionFactory.
    * @param b Should a Jaxr Connection Factory bound
    */
  void setDropDB(boolean b) ;

}

