/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.tm;

import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class TransactionPropagationContextUtil
{
   private static TransactionPropagationContextFactory tpcFactory;
   private static TransactionPropagationContextImporter tpcImporter;

   public static TransactionPropagationContextFactory getTPCFactoryClientSide()
   {
      return tpcFactory;
   }

   public static TransactionPropagationContextFactory getTPCFactory()
   {
      if (tpcFactory == null)
      {
         try
         {
            InitialContext ctx = new InitialContext();
            // Get the transaction propagation context factory
            tpcFactory = (TransactionPropagationContextFactory)
            ctx.lookup("java:/TransactionPropagationContextExporter");
         }
         catch (NamingException e)
         {
            throw new RuntimeException(e);  //To change body of catch statement use Options | File Templates.
         }
      }
      return tpcFactory;
   }

   public static void setTPCFactory(TransactionPropagationContextFactory tpcFactory)
   {
      TransactionPropagationContextUtil.tpcFactory = tpcFactory;
   }

   public static TransactionPropagationContextImporter getTPCImporter()
   {
      if (tpcImporter == null)
      {
         try
         {
            InitialContext ctx = new InitialContext();
            // and the transaction propagation context importer
            tpcImporter = (TransactionPropagationContextImporter)
            ctx.lookup("java:/TransactionPropagationContextImporter");
         }
         catch (NamingException e)
         {
            throw new RuntimeException(e);  //To change body of catch statement use Options | File Templates.
         }
      }
      return tpcImporter;
   }

   public static void setTPCImporter(TransactionPropagationContextImporter importer)
   {
      tpcImporter = importer;
   }
}
