/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.tomcat.tc5.session;

import org.jboss.web.tomcat.statistics.ReplicationStatistics;

/**
 * The MBean-interface for the ClusterManager
 *
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision:1$
 * @see org.jboss.ha.httpsession.server.ClusteredHTTPSessionService
 */
public interface JBossManagerMBean
{
   public ReplicationStatistics getReplicationStatistics();

   public void resetStats();

   public long timeInSecondsSinceLastReset();

   public long getActiveSessionCount();

   public long getRejectedSessionCount();

   public long getCreatedSessionCount();

   public long getExpiredSessionCount();

   public String reportReplicationStatistics();
}
